/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.crypto.encodings;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricBlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.CipherParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.savignano.thirdparty.org.bouncycastle.crypto.DataLengthException;
import net.savignano.thirdparty.org.bouncycastle.crypto.Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.ExtendedDigest;
import net.savignano.thirdparty.org.bouncycastle.crypto.InvalidCipherTextException;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ParametersWithRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.util.DigestFactory;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.Bytes;
import net.savignano.thirdparty.org.bouncycastle.util.Memoable;
import net.savignano.thirdparty.org.bouncycastle.util.Pack;

public class OAEPEncoding
implements AsymmetricBlockCipher {
    private final AsymmetricBlockCipher engine;
    private final Digest mgf1Hash;
    private final int mgf1NoMemoLimit;
    private final byte[] defHash;
    private SecureRandom random;
    private boolean forEncryption;

    private static int getMGF1NoMemoLimit(Digest d) {
        if (d instanceof Memoable && d instanceof ExtendedDigest) {
            return ((ExtendedDigest)d).getByteLength() - 1;
        }
        return Integer.MAX_VALUE;
    }

    public OAEPEncoding(AsymmetricBlockCipher cipher) {
        this(cipher, DigestFactory.createSHA1(), null);
    }

    public OAEPEncoding(AsymmetricBlockCipher cipher, Digest hash) {
        this(cipher, hash, null);
    }

    public OAEPEncoding(AsymmetricBlockCipher cipher, Digest hash, byte[] encodingParams) {
        this(cipher, hash, hash, encodingParams);
    }

    public OAEPEncoding(AsymmetricBlockCipher cipher, Digest hash, Digest mgf1Hash, byte[] encodingParams) {
        this.engine = cipher;
        this.mgf1Hash = mgf1Hash;
        this.mgf1NoMemoLimit = OAEPEncoding.getMGF1NoMemoLimit(mgf1Hash);
        this.defHash = new byte[hash.getDigestSize()];
        hash.reset();
        if (encodingParams != null) {
            hash.update(encodingParams, 0, encodingParams.length);
        }
        hash.doFinal(this.defHash, 0);
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        SecureRandom initRandom = null;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            initRandom = rParam.getRandom();
        }
        this.random = forEncryption ? CryptoServicesRegistrar.getSecureRandom(initRandom) : null;
        this.forEncryption = forEncryption;
        this.engine.init(forEncryption, param);
    }

    @Override
    public int getInputBlockSize() {
        int baseBlockSize = this.engine.getInputBlockSize();
        if (this.forEncryption) {
            return baseBlockSize - 1 - 2 * this.defHash.length;
        }
        return baseBlockSize;
    }

    @Override
    public int getOutputBlockSize() {
        int baseBlockSize = this.engine.getOutputBlockSize();
        if (this.forEncryption) {
            return baseBlockSize;
        }
        return baseBlockSize - 1 - 2 * this.defHash.length;
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(in, inOff, inLen);
        }
        return this.decodeBlock(in, inOff, inLen);
    }

    public byte[] encodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        int inputBlockSize = this.getInputBlockSize();
        if (inLen > inputBlockSize) {
            throw new DataLengthException("input data too long");
        }
        byte[] block = new byte[inputBlockSize + 1 + 2 * this.defHash.length];
        System.arraycopy(in, inOff, block, block.length - inLen, inLen);
        block[block.length - inLen - 1] = 1;
        System.arraycopy(this.defHash, 0, block, this.defHash.length, this.defHash.length);
        byte[] seed = new byte[this.defHash.length];
        this.random.nextBytes(seed);
        System.arraycopy(seed, 0, block, 0, this.defHash.length);
        this.mgf1Hash.reset();
        this.maskGeneratorFunction1(seed, 0, seed.length, block, this.defHash.length, block.length - this.defHash.length);
        this.maskGeneratorFunction1(block, this.defHash.length, block.length - this.defHash.length, block, 0, this.defHash.length);
        return this.engine.processBlock(block, 0, block.length);
    }

    public byte[] decodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        int wrongMask = this.getOutputBlockSize() >> 31;
        byte[] block = new byte[this.engine.getOutputBlockSize()];
        byte[] data = this.engine.processBlock(in, inOff, inLen);
        wrongMask |= block.length - data.length >> 31;
        int copyLen = Math.min(block.length, data.length);
        System.arraycopy(data, 0, block, block.length - copyLen, copyLen);
        Arrays.fill(data, (byte)0);
        this.mgf1Hash.reset();
        this.maskGeneratorFunction1(block, this.defHash.length, block.length - this.defHash.length, block, 0, this.defHash.length);
        this.maskGeneratorFunction1(block, 0, this.defHash.length, block, this.defHash.length, block.length - this.defHash.length);
        for (int i = 0; i != this.defHash.length; ++i) {
            wrongMask |= this.defHash[i] ^ block[this.defHash.length + i];
        }
        int start = -1;
        for (int index = 2 * this.defHash.length; index != block.length; ++index) {
            int octet = block[index] & 0xFF;
            int shouldSetMask = (-octet & start) >> 31;
            start += index & shouldSetMask;
        }
        wrongMask |= start >> 31;
        if ((wrongMask |= block[++start] ^ 1) != 0) {
            Arrays.fill(block, (byte)0);
            throw new InvalidCipherTextException("data wrong");
        }
        byte[] output = new byte[block.length - ++start];
        System.arraycopy(block, start, output, 0, output.length);
        Arrays.fill(block, (byte)0);
        return output;
    }

    private void maskGeneratorFunction1(byte[] z, int zOff, int zLen, byte[] mask, int maskOff, int maskLen) {
        int maskPos;
        int digestSize = this.mgf1Hash.getDigestSize();
        byte[] hash = new byte[digestSize];
        byte[] C = new byte[4];
        int counter = 0;
        int maskEnd = maskOff + maskLen;
        int maskLimit = maskEnd - digestSize;
        this.mgf1Hash.update(z, zOff, zLen);
        if (zLen > this.mgf1NoMemoLimit) {
            Memoable memoable = (Memoable)((Object)this.mgf1Hash);
            Memoable memo = memoable.copy();
            for (maskPos = maskOff; maskPos < maskLimit; maskPos += digestSize) {
                Pack.intToBigEndian(counter++, C, 0);
                this.mgf1Hash.update(C, 0, C.length);
                this.mgf1Hash.doFinal(hash, 0);
                memoable.reset(memo);
                Bytes.xorTo(digestSize, hash, 0, mask, maskPos);
            }
        } else {
            while (maskPos < maskLimit) {
                Pack.intToBigEndian(counter++, C, 0);
                this.mgf1Hash.update(C, 0, C.length);
                this.mgf1Hash.doFinal(hash, 0);
                this.mgf1Hash.update(z, zOff, zLen);
                Bytes.xorTo(digestSize, hash, 0, mask, maskPos);
                maskPos += digestSize;
            }
        }
        Pack.intToBigEndian(counter, C, 0);
        this.mgf1Hash.update(C, 0, C.length);
        this.mgf1Hash.doFinal(hash, 0);
        Bytes.xorTo(maskEnd - maskPos, hash, 0, mask, maskPos);
    }
}

