/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.gpg.keybox;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.Blob;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.BlobType;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.BlobVerifier;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.KeyBlob;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.KeyBoxByteBuffer;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.KeyInformation;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.UserID;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;

public class PublicKeyRingBlob
extends KeyBlob {
    private final KeyFingerPrintCalculator fingerPrintCalculator;

    private PublicKeyRingBlob(int base, long length, BlobType type, int version, int blobFlags, int keyNumber, List<KeyInformation> keyInformation, byte[] serialNumber, int numberOfUserIDs, List<UserID> userIds, int numberOfSignatures, List<Long> expirationTime, int assignedOwnerTrust, int allValidity, long recheckAfter, long newestTimestamp, long blobCreatedAt, byte[] keyBytes, byte[] reserveBytes, byte[] sha1Checksum, KeyFingerPrintCalculator fingerPrintCalculator) {
        super(base, length, type, version, blobFlags, keyNumber, keyInformation, serialNumber, numberOfUserIDs, userIds, numberOfSignatures, expirationTime, assignedOwnerTrust, allValidity, recheckAfter, newestTimestamp, blobCreatedAt, keyBytes, reserveBytes, sha1Checksum);
        this.fingerPrintCalculator = fingerPrintCalculator;
    }

    static Blob parseContent(int base, long length, BlobType type, int version, KeyBoxByteBuffer buffer, KeyFingerPrintCalculator fingerPrintCalculator, BlobVerifier blobVerifier) throws IOException {
        PublicKeyRingBlob.verifyDigest(base, length, buffer, blobVerifier);
        int blobFlags = buffer.u16();
        long keyBlockOffset = buffer.u32();
        long keyBlockLength = buffer.u32();
        int keyNumber = buffer.u16();
        int keyInformationStructureSize = buffer.u16();
        ArrayList<KeyInformation> keyInformation = new ArrayList<KeyInformation>();
        for (int t = keyNumber - 1; t >= 0; --t) {
            keyInformation.add(KeyInformation.getInstance(buffer, keyInformationStructureSize, base));
        }
        int sizeOfSerialNumber = buffer.u16();
        byte[] serialNumber = buffer.bN(sizeOfSerialNumber);
        int numberOfUserIDs = buffer.u16();
        buffer.u16();
        ArrayList<UserID> userIds = new ArrayList<UserID>();
        for (int t = numberOfUserIDs - 1; t >= 0; --t) {
            userIds.add(UserID.getInstance(buffer, base));
        }
        int numberOfSignatures = buffer.u16();
        buffer.u16();
        ArrayList<Long> signatureExpirationTime = new ArrayList<Long>();
        for (int t = numberOfSignatures - 1; t >= 0; --t) {
            signatureExpirationTime.add(buffer.u32());
        }
        int assignedOwnerTrust = buffer.u8();
        int allValidity = buffer.u8();
        buffer.u16();
        long recheckAfter = buffer.u32();
        long newestTimestamp = buffer.u32();
        long blobCreatedAt = buffer.u32();
        long sizeOfReservedSpace = buffer.u32();
        if (sizeOfReservedSpace > (long)buffer.remaining()) {
            throw new IllegalStateException("sizeOfReservedSpace exceeds content remaining in buffer");
        }
        byte[] reserveData = buffer.bN((int)sizeOfReservedSpace);
        byte[] keyData = buffer.rangeOf((int)((long)base + keyBlockOffset), (int)((long)base + keyBlockOffset + keyBlockLength));
        int dataSize = (int)(length - (long)(buffer.position() - base) - 20L);
        byte[] data = buffer.bN(dataSize);
        byte[] checksum = buffer.rangeOf((int)((long)base + length - 20L), (int)((long)base + length));
        buffer.consume(checksum.length);
        return new PublicKeyRingBlob(base, length, type, version, blobFlags, keyNumber, keyInformation, serialNumber, numberOfUserIDs, userIds, numberOfSignatures, signatureExpirationTime, assignedOwnerTrust, allValidity, recheckAfter, newestTimestamp, blobCreatedAt, keyData, reserveData, checksum, fingerPrintCalculator);
    }

    public PGPPublicKeyRing getPGPPublicKeyRing() throws IOException {
        if (this.type == BlobType.OPEN_PGP_BLOB) {
            return new PGPPublicKeyRing(this.getKeyBytes(), this.fingerPrintCalculator);
        }
        throw new IllegalStateException("Blob is not PGP blob, it is " + this.type.name());
    }
}

