/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp;

import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import net.savignano.thirdparty.org.bouncycastle.bcpg.AEADEncDataPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGHeaderObject;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGOutputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ContainedPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.InputStreamPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SymmetricEncDataPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SymmetricKeyAlgorithmTags;
import net.savignano.thirdparty.org.bouncycastle.openpgp.AEADUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.StreamGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.WrappedGeneratorStream;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPAEADDataEncryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDataEncryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import net.savignano.thirdparty.org.bouncycastle.util.io.TeeOutputStream;

public class PGPEncryptedDataGenerator
implements SymmetricKeyAlgorithmTags,
StreamGenerator {
    public static final int S2K_SHA1 = 2;
    public static final int S2K_SHA224 = 11;
    public static final int S2K_SHA256 = 8;
    public static final int S2K_SHA384 = 9;
    public static final int S2K_SHA512 = 10;
    private BCPGOutputStream pOut;
    private OutputStream cOut;
    private boolean useOldFormat = false;
    private PGPDigestCalculator digestCalc;
    private OutputStream genOut;
    private PGPDataEncryptorBuilder dataEncryptorBuilder;
    private byte[] salt = new byte[32];
    private List<PGPKeyEncryptionMethodGenerator> methods = new ArrayList<PGPKeyEncryptionMethodGenerator>();
    private int defAlgorithm;
    private SecureRandom rand;
    private boolean forceSessionKey = false;

    public PGPEncryptedDataGenerator(PGPDataEncryptorBuilder encryptorBuilder) {
        this(encryptorBuilder, false);
    }

    public PGPEncryptedDataGenerator(PGPDataEncryptorBuilder encryptorBuilder, boolean oldFormat) {
        this.dataEncryptorBuilder = encryptorBuilder;
        this.useOldFormat = oldFormat;
        this.defAlgorithm = this.dataEncryptorBuilder.getAlgorithm();
        this.rand = this.dataEncryptorBuilder.getSecureRandom();
        this.rand.nextBytes(this.salt);
    }

    public void setForceSessionKey(boolean forceSessionKey) {
        this.forceSessionKey = forceSessionKey;
    }

    public void addMethod(PGPKeyEncryptionMethodGenerator method) {
        this.methods.add(method);
    }

    private void addCheckSum(byte[] sessionInfo) {
        int check = 0;
        for (int i = 1; i != sessionInfo.length - 2; ++i) {
            check += sessionInfo[i] & 0xFF;
        }
        sessionInfo[sessionInfo.length - 2] = (byte)(check >> 8);
        sessionInfo[sessionInfo.length - 1] = (byte)check;
    }

    private byte[] createSessionInfo(int algorithm, byte[] keyBytes) {
        byte[] sessionInfo = new byte[keyBytes.length + 3];
        sessionInfo[0] = (byte)algorithm;
        System.arraycopy(keyBytes, 0, sessionInfo, 1, keyBytes.length);
        this.addCheckSum(sessionInfo);
        return sessionInfo;
    }

    private OutputStream open(OutputStream out, long length, byte[] buffer) throws IOException, PGPException, IllegalStateException {
        byte[] sessionInfo;
        byte[] sessionKey;
        boolean directS2K;
        if (this.cOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        if (this.methods.size() == 0) {
            throw new IllegalStateException("no encryption methods specified");
        }
        this.pOut = new BCPGOutputStream(out, !this.useOldFormat);
        this.defAlgorithm = this.dataEncryptorBuilder.getAlgorithm();
        this.rand = this.dataEncryptorBuilder.getSecureRandom();
        boolean bl = directS2K = !this.forceSessionKey && this.methods.size() == 1 && this.methods.get(0) instanceof PBEKeyEncryptionMethodGenerator;
        if (directS2K) {
            sessionKey = ((PBEKeyEncryptionMethodGenerator)this.methods.get(0)).getKey(this.defAlgorithm);
            sessionInfo = null;
        } else {
            sessionKey = PGPUtil.makeRandomKey(this.defAlgorithm, this.rand);
            sessionInfo = this.createSessionInfo(this.defAlgorithm, sessionKey);
        }
        byte[] messageKey = sessionKey;
        boolean isV5StyleAEAD = this.dataEncryptorBuilder.isV5StyleAEAD();
        if (this.dataEncryptorBuilder.getAeadAlgorithm() != -1 && !isV5StyleAEAD) {
            byte[] info = SymmetricEncIntegrityPacket.createAAData(2, this.defAlgorithm, this.dataEncryptorBuilder.getAeadAlgorithm(), this.dataEncryptorBuilder.getChunkSize());
            messageKey = AEADUtil.deriveMessageKeyAndIv(this.dataEncryptorBuilder.getAeadAlgorithm(), this.defAlgorithm, sessionKey, this.salt, info);
        }
        PGPDataEncryptor dataEncryptor = this.dataEncryptorBuilder.build(messageKey);
        this.digestCalc = dataEncryptor.getIntegrityCalculator();
        for (int i = 0; i < this.methods.size(); ++i) {
            PGPKeyEncryptionMethodGenerator method = this.methods.get(i);
            if (dataEncryptor instanceof PGPAEADDataEncryptor) {
                PGPAEADDataEncryptor aeadDataEncryptor = (PGPAEADDataEncryptor)dataEncryptor;
                if (isV5StyleAEAD) {
                    this.writeOpenPGPv5ESKPacket(method, sessionInfo);
                    continue;
                }
                this.writeOpenPGPv6ESKPacket(method, aeadDataEncryptor.getAEADAlgorithm(), sessionInfo);
                continue;
            }
            this.writeOpenPGPv4ESKPacket(method, sessionInfo);
        }
        try {
            if (dataEncryptor instanceof PGPAEADDataEncryptor) {
                long ivOrSaltLen;
                InputStreamPacket encOut;
                PGPAEADDataEncryptor encryptor = (PGPAEADDataEncryptor)dataEncryptor;
                if (isV5StyleAEAD) {
                    byte[] iv = encryptor.getIV();
                    encOut = new AEADEncDataPacket(this.dataEncryptorBuilder.getAlgorithm(), encryptor.getAEADAlgorithm(), encryptor.getChunkSize(), iv);
                    ivOrSaltLen = iv.length;
                } else {
                    encOut = SymmetricEncIntegrityPacket.createVersion2Packet(this.dataEncryptorBuilder.getAlgorithm(), encryptor.getAEADAlgorithm(), encryptor.getChunkSize(), this.salt);
                    ivOrSaltLen = this.salt.length;
                }
                if (buffer != null) {
                    this.pOut = new ClosableBCPGOutputStream(out, (BCPGHeaderObject)((Object)encOut), buffer);
                } else {
                    long chunkLength = 1L << encryptor.getChunkSize() + 6;
                    long tagLengths = (length + chunkLength - 1L) / chunkLength * 16L + 16L;
                    this.pOut = new ClosableBCPGOutputStream(out, (BCPGHeaderObject)((Object)encOut), length + tagLengths + 4L + ivOrSaltLen);
                }
                this.genOut = this.cOut = dataEncryptor.getOutputStream(this.pOut);
            } else {
                InputStreamPacket encOut;
                if (this.digestCalc != null) {
                    encOut = new SymmetricEncIntegrityPacket();
                    if (this.useOldFormat) {
                        throw new PGPException("symmetric-enc-integrity packets not supported in old PGP format");
                    }
                } else {
                    encOut = new SymmetricEncDataPacket();
                }
                if (buffer == null) {
                    long outLength = this.digestCalc == null ? length + (long)dataEncryptor.getBlockSize() + 2L : length + (long)dataEncryptor.getBlockSize() + 2L + 1L + 22L;
                    this.pOut = new ClosableBCPGOutputStream(out, (BCPGHeaderObject)((Object)encOut), outLength, this.useOldFormat);
                } else {
                    this.pOut = new ClosableBCPGOutputStream(out, (BCPGHeaderObject)((Object)encOut), buffer);
                }
                this.genOut = this.cOut = dataEncryptor.getOutputStream(this.pOut);
                if (this.digestCalc != null) {
                    this.genOut = new TeeOutputStream(this.digestCalc.getOutputStream(), this.cOut);
                }
                byte[] inLineIv = new byte[dataEncryptor.getBlockSize() + 2];
                this.rand.nextBytes(inLineIv);
                inLineIv[inLineIv.length - 1] = inLineIv[inLineIv.length - 3];
                inLineIv[inLineIv.length - 2] = inLineIv[inLineIv.length - 4];
                this.genOut.write(inLineIv);
            }
            return new WrappedGeneratorStream(this.genOut, this);
        }
        catch (Exception e) {
            throw new PGPException("Exception creating cipher", e);
        }
    }

    private void writeOpenPGPv4ESKPacket(PGPKeyEncryptionMethodGenerator m, byte[] sessionInfo) throws IOException, PGPException {
        if (m instanceof PBEKeyEncryptionMethodGenerator) {
            PBEKeyEncryptionMethodGenerator mGen = (PBEKeyEncryptionMethodGenerator)m;
            ContainedPacket esk = m.generate(mGen.getSessionKeyWrapperAlgorithm(this.defAlgorithm), sessionInfo);
            this.pOut.writePacket(esk);
        } else {
            this.pOut.writePacket(m.generate(this.defAlgorithm, sessionInfo));
        }
    }

    private void writeOpenPGPv5ESKPacket(PGPKeyEncryptionMethodGenerator m, byte[] sessionInfo) throws IOException, PGPException {
        if (m instanceof PBEKeyEncryptionMethodGenerator) {
            PBEKeyEncryptionMethodGenerator mGen = (PBEKeyEncryptionMethodGenerator)m;
            ContainedPacket esk = m.generateV5(mGen.getSessionKeyWrapperAlgorithm(this.defAlgorithm), this.dataEncryptorBuilder.getAeadAlgorithm(), sessionInfo);
            this.pOut.writePacket(esk);
        } else {
            this.pOut.writePacket(m.generate(this.defAlgorithm, sessionInfo));
        }
    }

    private void writeOpenPGPv6ESKPacket(PGPKeyEncryptionMethodGenerator m, int aeadAlgorithm, byte[] sessionInfo) throws IOException, PGPException {
        if (m instanceof PBEKeyEncryptionMethodGenerator) {
            PBEKeyEncryptionMethodGenerator mGen = (PBEKeyEncryptionMethodGenerator)m;
            ContainedPacket esk = m.generateV6(mGen.getSessionKeyWrapperAlgorithm(this.defAlgorithm), aeadAlgorithm, sessionInfo);
            this.pOut.writePacket(esk);
        } else {
            this.pOut.writePacket(m.generate(this.defAlgorithm, sessionInfo));
        }
    }

    public OutputStream open(OutputStream out, long length) throws IOException, PGPException {
        return this.open(out, length, null);
    }

    public OutputStream open(OutputStream out, byte[] buffer) throws IOException, PGPException {
        return this.open(out, 0L, buffer);
    }

    @Override
    public void close() throws IOException {
        if (this.cOut != null) {
            if (this.digestCalc != null) {
                BCPGOutputStream bOut = new BCPGOutputStream(this.genOut, 19, 20L);
                bOut.flush();
                byte[] dig = this.digestCalc.getDigest();
                this.cOut.write(dig);
            }
            this.cOut.close();
            this.cOut = null;
            this.pOut = null;
        }
    }

    private static class ClosableBCPGOutputStream
    extends BCPGOutputStream {
        public ClosableBCPGOutputStream(OutputStream out, BCPGHeaderObject header, byte[] buffer) throws IOException {
            super(out, header.getType(), buffer);
            header.encode(this);
        }

        public ClosableBCPGOutputStream(OutputStream out, BCPGHeaderObject header, long length, boolean useOldIfPossible) throws IOException {
            super(out, header.getType(), length, useOldIfPossible);
            header.encode(this);
        }

        public ClosableBCPGOutputStream(OutputStream out, BCPGHeaderObject header, long length) throws IOException {
            super(out, header.getType(), length);
            header.encode(this);
        }

        @Override
        public void close() throws IOException {
            this.finish();
        }
    }
}

