/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.BlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.BufferedBlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.InvalidCipherTextException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;

public class BcPBESecretKeyEncryptorBuilder {
    private int encAlgorithm;
    private PGPDigestCalculator s2kDigestCalculator;
    private SecureRandom random;
    private int s2kCount = 96;

    public BcPBESecretKeyEncryptorBuilder(int encAlgorithm) {
        this(encAlgorithm, new SHA1PGPDigestCalculator());
    }

    public BcPBESecretKeyEncryptorBuilder(int encAlgorithm, int s2kCount) {
        this(encAlgorithm, new SHA1PGPDigestCalculator(), s2kCount);
    }

    public BcPBESecretKeyEncryptorBuilder(int encAlgorithm, PGPDigestCalculator s2kDigestCalculator) {
        this(encAlgorithm, s2kDigestCalculator, 96);
    }

    public BcPBESecretKeyEncryptorBuilder(int encAlgorithm, PGPDigestCalculator s2kDigestCalculator, int s2kCount) {
        this.encAlgorithm = encAlgorithm;
        this.s2kDigestCalculator = s2kDigestCalculator;
        if (s2kCount < 0 || s2kCount > 255) {
            throw new IllegalArgumentException("s2KCount value outside of range 0 to 255.");
        }
        this.s2kCount = s2kCount;
    }

    public BcPBESecretKeyEncryptorBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public PBESecretKeyEncryptor build(char[] passPhrase) {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        return new PBESecretKeyEncryptor(this.encAlgorithm, this.s2kDigestCalculator, this.s2kCount, this.random, passPhrase){
            private byte[] iv;

            @Override
            public byte[] encryptKeyData(byte[] key, byte[] keyData, int keyOff, int keyLen) throws PGPException {
                return this.encryptKeyData(key, null, keyData, keyOff, keyLen);
            }

            @Override
            public byte[] encryptKeyData(byte[] key, byte[] iv, byte[] keyData, int keyOff, int keyLen) throws PGPException {
                try {
                    BlockCipher engine = BcImplProvider.createBlockCipher(this.encAlgorithm);
                    if (iv != null) {
                        this.iv = iv;
                    } else {
                        if (this.random == null) {
                            this.random = new SecureRandom();
                        }
                        iv = new byte[engine.getBlockSize()];
                        this.iv = iv;
                        this.random.nextBytes(iv);
                    }
                    BufferedBlockCipher c = BcUtil.createSymmetricKeyWrapper(true, engine, key, iv);
                    byte[] out = new byte[keyLen];
                    int outLen = c.processBytes(keyData, keyOff, keyLen, out, 0);
                    outLen += c.doFinal(out, outLen);
                    return out;
                }
                catch (InvalidCipherTextException e) {
                    throw new PGPException("decryption failed: " + e.getMessage(), e);
                }
            }

            @Override
            public byte[] getCipherIV() {
                return this.iv;
            }
        };
    }
}

