/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.protocols;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import net.savignano.uptrust.proxy.imap.ProxyImapDecoderFactory;
import net.savignano.uptrust.proxy.imap.ProxyImapEncoderFactory;
import net.savignano.uptrust.proxy.imap.ProxyImapProcessorFactory;
import net.savignano.uptrust.service.IUptrustService;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.decode.ImapDecoder;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imapserver.netty.IMAPServerFactory;
import org.apache.james.imapserver.netty.OioIMAPServerFactory;
import org.apache.james.modules.protocols.ImapGuiceProbe;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.utils.GuiceProbe;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;

public class IMAPServerModule
extends AbstractModule {
    protected void configure() {
        this.bind(IMAPServerFactory.class).in(Scopes.SINGLETON);
        this.bind(OioIMAPServerFactory.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)this.binder(), GuiceProbe.class).addBinding().to(ImapGuiceProbe.class);
    }

    @Provides
    ImapProcessor provideImapProcessor(IUptrustService uptrustService) {
        return ProxyImapProcessorFactory.createProcessor((IUptrustService)uptrustService);
    }

    @Provides
    @Singleton
    ImapDecoder provideImapDecoder(IUptrustService uptrustService) {
        return ProxyImapDecoderFactory.createDecoder((IUptrustService)uptrustService);
    }

    @Provides
    @Singleton
    ImapEncoder provideImapEncoder(IUptrustService uptrustService) {
        return ProxyImapEncoderFactory.createEncoder((IUptrustService)uptrustService, null);
    }

    @ProvidesIntoSet
    InitializationOperation configureImap(ConfigurationProvider configurationProvider, IMAPServerFactory imapServerFactory) {
        return InitilizationOperationBuilder.forClass(IMAPServerFactory.class).init(() -> {
            imapServerFactory.configure(configurationProvider.getConfiguration("imapserver"));
            imapServerFactory.init();
        });
    }
}

