/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.google.common.base.MoreObjects;
import java.time.Clock;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.core.Username;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.james.webadmin.service.UserMailboxesService;
import org.apache.james.webadmin.validation.MailboxName;
import reactor.core.scheduler.Schedulers;

public class ClearMailboxContentTask
implements Task {
    public static final TaskType TASK_TYPE = TaskType.of((String)"ClearMailboxContentTask");
    private final Context context;
    private final Username username;
    private final MailboxName mailboxName;
    private final UserMailboxesService userMailboxesService;

    public ClearMailboxContentTask(Username username, MailboxName mailboxName, UserMailboxesService userMailboxesService) {
        this.username = username;
        this.mailboxName = mailboxName;
        this.userMailboxesService = userMailboxesService;
        this.context = new Context();
    }

    public Task.Result run() {
        return (Task.Result)this.userMailboxesService.clearMailboxContent(this.username, this.mailboxName, this.context).subscribeOn(Schedulers.elastic()).block();
    }

    public TaskType type() {
        return TASK_TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(AdditionalInformation.from(this.username, this.mailboxName, this.context));
    }

    public Username getUsername() {
        return this.username;
    }

    public MailboxName getMailboxName() {
        return this.mailboxName;
    }

    public static class Context {
        private final AtomicLong messagesSuccessCount;
        private final AtomicLong messagesFailedCount;

        public Context() {
            this.messagesSuccessCount = new AtomicLong();
            this.messagesFailedCount = new AtomicLong();
        }

        public Context(long messagesSuccessCount, long messagesFailedCount) {
            this.messagesSuccessCount = new AtomicLong(messagesSuccessCount);
            this.messagesFailedCount = new AtomicLong(messagesFailedCount);
        }

        public void incrementSuccesses() {
            this.messagesSuccessCount.incrementAndGet();
        }

        public void incrementMessageFails() {
            this.messagesFailedCount.incrementAndGet();
        }

        public Snapshot snapshot() {
            return new Snapshot(this.messagesSuccessCount.get(), this.messagesFailedCount.get());
        }

        public static class Snapshot {
            private final long messagesSuccessCount;
            private final long messagesFailedCount;

            private Snapshot(long messagesSuccessCount, long messagesFailedCount) {
                this.messagesSuccessCount = messagesSuccessCount;
                this.messagesFailedCount = messagesFailedCount;
            }

            public long getMessagesSuccessCount() {
                return this.messagesSuccessCount;
            }

            public long getMessagesFailedCount() {
                return this.messagesFailedCount;
            }

            public final boolean equals(Object o) {
                if (o instanceof Snapshot) {
                    Snapshot that = (Snapshot)o;
                    return Objects.equals(this.messagesSuccessCount, that.messagesSuccessCount) && Objects.equals(this.messagesFailedCount, that.messagesFailedCount);
                }
                return false;
            }

            public final int hashCode() {
                return Objects.hash(this.messagesSuccessCount, this.messagesFailedCount);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("messagesSuccessCount", this.messagesSuccessCount).add("messagesFailedCount", this.messagesFailedCount).toString();
            }
        }
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final Username username;
        private final MailboxName mailboxName;
        private final Instant timestamp;
        private final long messagesSuccessCount;
        private final long messagesFailCount;

        private static AdditionalInformation from(Username username, MailboxName mailboxName, Context context) {
            Context.Snapshot snapshot = context.snapshot();
            return new AdditionalInformation(username, mailboxName, Clock.systemUTC().instant(), snapshot.messagesSuccessCount, snapshot.messagesFailedCount);
        }

        public AdditionalInformation(Username username, MailboxName mailboxName, Instant timestamp, long messagesSuccessCount, long messagesFailCount) {
            this.username = username;
            this.mailboxName = mailboxName;
            this.timestamp = timestamp;
            this.messagesSuccessCount = messagesSuccessCount;
            this.messagesFailCount = messagesFailCount;
        }

        public Username getUsername() {
            return this.username;
        }

        public MailboxName getMailboxName() {
            return this.mailboxName;
        }

        public Instant getTimestamp() {
            return this.timestamp;
        }

        public long getMessagesSuccessCount() {
            return this.messagesSuccessCount;
        }

        public long getMessagesFailCount() {
            return this.messagesFailCount;
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }
}

