/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service;

import java.security.KeyStore;
import java.security.cert.PKIXParameters;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.mail.visitor.specific.DetectCryptographyVisitor;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.cryptography.version.ProductInformation;
import net.savignano.uptrust.service.IUptrustService;
import net.savignano.uptrust.service.cryptography.IDecryptionService;
import net.savignano.uptrust.service.cryptography.IEncryptionService;
import net.savignano.uptrust.service.cryptography.IExtractionService;
import net.savignano.uptrust.service.cryptography.ISigningService;
import net.savignano.uptrust.service.cryptography.IValidationService;
import net.savignano.uptrust.service.cryptography.config.DecryptionServiceBuilder;
import net.savignano.uptrust.service.cryptography.config.DecryptionServiceConfiguration;
import net.savignano.uptrust.service.cryptography.config.EncryptionServiceBuilder;
import net.savignano.uptrust.service.cryptography.config.ExtractionServiceBuilder;
import net.savignano.uptrust.service.cryptography.config.SigningServiceBuilder;
import net.savignano.uptrust.service.cryptography.config.ValidationServiceBuilder;
import net.savignano.uptrust.service.decorator.DecoratorServiceBuilder;
import net.savignano.uptrust.service.decorator.IDecoratorService;
import net.savignano.uptrust.service.key.IKeyService;
import net.savignano.uptrust.service.key.KeyServiceBuilder;
import net.savignano.uptrust.service.license.ILicenseService;
import net.savignano.uptrust.service.license.LicenseServiceBuilder;
import net.savignano.uptrust.service.license.LicenseValidationKey;
import net.savignano.uptrust.service.password.IPasswordService;
import net.savignano.uptrust.service.password.PasswordService;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.slf4j.LoggerFactory;

public class UptrustService
implements IUptrustService {
    private static final String ENABLED_KEY = "enabled";
    private static final String LICENSE_KEY = "license";
    private static final String KEY_MANAGMENT_KEY = "keyManagement";
    private static final String DECORATION_SETTINGS_KEY = "decoration";
    private static final String DECRYPTION_SETTINGS_KEY = "cryptography.decryption";
    private static final String ENCRYPTION_SETTINGS_KEY = "cryptography.encryption";
    private static final String SIGNING_SETTINGS_KEY = "cryptography.signing";
    private static final String VALIDATION_SETTINGS_KEY = "cryptography.validation";
    private static final String EXTRACTION_SETTINGS_KEY = "cryptography.extraction";
    private final HierarchicalConfiguration<ImmutableNode> config;
    private final Session session;
    private final ProductInformation productInfo;
    private final boolean disabled;
    private IKeyService keyService;
    private IDecryptionService decryptionService;
    private IEncryptionService encryptionService;
    private ISigningService signingService;
    private IValidationService validationService;
    private IExtractionService extractionService;
    private IDecoratorService decoratorService;
    private IPasswordService passwordService;
    private ILicenseService licenseService;

    public UptrustService(HierarchicalConfiguration<ImmutableNode> config, Session session) {
        this.config = config;
        this.session = session;
        this.productInfo = new ProductInformation("Uptrust", ProductInformation.loadVersion(), ProductInformation.loadHostName());
        this.disabled = !config.getBoolean(ENABLED_KEY, true);
    }

    @Override
    public HierarchicalConfiguration<ImmutableNode> getConfig() {
        return this.config;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public ECryptographyType determineCryptography(MimeMessage msg) {
        DetectCryptographyVisitor visitor = this.getDetectCryptoVisitor();
        try {
            visitor.visit(msg);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Could not determine cryptography of message with ID \"" + MessageUtil.getMessageId((Message)msg) + "\". Error message: " + e.getMessage(), (Throwable)e);
            return ECryptographyType.NONE;
        }
        return (ECryptographyType)visitor.getResult();
    }

    @Override
    public ProductInformation getProductInfo() {
        return this.productInfo;
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public IKeyService getKeyService() {
        if (this.keyService == null) {
            this.keyService = KeyServiceBuilder.from(this.config.immutableConfigurationAt(KEY_MANAGMENT_KEY), ((PasswordService)this.getPasswordService())::getDecoder).build();
        }
        return this.keyService;
    }

    @Override
    public IDecryptionService getDecryptionService() {
        if (this.decryptionService == null) {
            this.decryptionService = ((DecryptionServiceBuilder)((DecryptionServiceBuilder)((DecryptionServiceBuilder)DecryptionServiceBuilder.from((ImmutableConfiguration)this.config.immutableConfigurationAt(DECRYPTION_SETTINGS_KEY)).productInfo(this.getProductInfo())).session(this.getSession())).keyService(this.getKeyService())).build();
        }
        return this.decryptionService;
    }

    @Override
    public IEncryptionService getEncryptionService() {
        if (this.encryptionService == null) {
            this.encryptionService = ((EncryptionServiceBuilder)((EncryptionServiceBuilder)((EncryptionServiceBuilder)EncryptionServiceBuilder.from((ImmutableConfiguration)this.config.immutableConfigurationAt(ENCRYPTION_SETTINGS_KEY)).productInfo(this.getProductInfo())).session(this.getSession())).keyService(this.getKeyService())).build();
        }
        return this.encryptionService;
    }

    @Override
    public ISigningService getSigningService() {
        if (this.signingService == null) {
            this.signingService = ((SigningServiceBuilder)((SigningServiceBuilder)((SigningServiceBuilder)SigningServiceBuilder.from((ImmutableConfiguration)this.config.immutableConfigurationAt(SIGNING_SETTINGS_KEY)).productInfo(this.getProductInfo())).session(this.getSession())).keyService(this.getKeyService())).build();
        }
        return this.signingService;
    }

    @Override
    public IValidationService getValidationService() {
        if (this.validationService == null) {
            this.validationService = ((ValidationServiceBuilder)((ValidationServiceBuilder)((ValidationServiceBuilder)ValidationServiceBuilder.from((ImmutableConfiguration)this.config.immutableConfigurationAt(VALIDATION_SETTINGS_KEY)).productInfo(this.getProductInfo())).session(this.getSession())).keyService(this.getKeyService())).smimePkix(UptrustService.createPkix()).build();
        }
        return this.validationService;
    }

    @Override
    public IExtractionService getExtractionService() {
        if (this.extractionService == null) {
            this.extractionService = ((ExtractionServiceBuilder)((ExtractionServiceBuilder)((ExtractionServiceBuilder)ExtractionServiceBuilder.from((ImmutableConfiguration)this.config.immutableConfigurationAt(EXTRACTION_SETTINGS_KEY)).productInfo(this.getProductInfo())).session(this.getSession())).keyService(this.getKeyService())).build();
        }
        return this.extractionService;
    }

    @Override
    public IPasswordService getPasswordService() {
        if (this.passwordService == null) {
            this.passwordService = new PasswordService();
        }
        return this.passwordService;
    }

    @Override
    public IDecoratorService getDecoratorService() {
        if (this.decoratorService == null) {
            this.decoratorService = DecoratorServiceBuilder.from((ImmutableConfiguration)this.config.immutableConfigurationAt(DECORATION_SETTINGS_KEY)).build();
        }
        return this.decoratorService;
    }

    @Override
    public ILicenseService getLicenseService() {
        if (this.licenseService == null) {
            this.licenseService = LicenseServiceBuilder.from((ImmutableConfiguration)this.config.immutableConfigurationAt(LICENSE_KEY)).validateWith(LicenseValidationKey.KEY).build();
            if (!this.licenseService.isValid()) {
                LoggerFactory.getLogger(this.getClass()).error("No valid license configured for Uptrust. Cryptographic protection will not be applied to emails.");
            }
        }
        return this.licenseService;
    }

    private DetectCryptographyVisitor getDetectCryptoVisitor() {
        DecryptionServiceConfiguration decConfig = DecryptionServiceBuilder.from((ImmutableConfiguration)this.config.immutableConfigurationAt(DECRYPTION_SETTINGS_KEY)).getConfig();
        DetectCryptographyVisitor detectCryptoVisitor = new DetectCryptographyVisitor();
        detectCryptoVisitor.setBinaryRegex(decConfig.getPgpBinaryRegex());
        detectCryptoVisitor.setCheckInline(decConfig.isPgpCheckInline());
        return detectCryptoVisitor;
    }

    private static final PKIXParameters createPkix() {
        KeyStore javaTrustStore = null;
        try {
            javaTrustStore = SecurityUtil.getJavaTrustStore();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(UptrustService.class).error("Could not load java trust store. Certificate Chain will not be validated. Error message: " + e.getMessage(), (Throwable)e);
        }
        PKIXParameters params = null;
        if (javaTrustStore != null) {
            try {
                params = new PKIXParameters(javaTrustStore);
                params.setRevocationEnabled(false);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(UptrustService.class).error("Could not create validation parameters. Certification chain will not be validated. Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        return params;
    }
}

