/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.config.converter;

import java.util.NoSuchElementException;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConverter<T, R, SELF extends BaseConverter<T, R, SELF>> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseConverter.class);
    private final SELF self = this;
    private final String name;
    private T fromValue;
    private NoSuchElementException notFoundExc;

    protected BaseConverter(String name) {
        this.name = name;
    }

    public SELF from(ImmutableConfiguration config, String key) {
        LOG.trace("Getting \"{}\" from config with key: {}", (Object)this.name, (Object)key);
        try {
            this.from(this.fromConfig(config, key));
        }
        catch (NoSuchElementException e) {
            LOG.trace("No value for \"{}\" provided at key: {}", (Object)this.name, (Object)key);
            this.notFoundExc = e;
        }
        return this.self;
    }

    public SELF from(T value) {
        this.notFoundExc = null;
        this.fromValue = value;
        return this.self;
    }

    public R get() throws ConfigurationException {
        LOG.trace("Getting \"{}\" value.", (Object)this.name);
        if (this.notFoundExc != null) {
            throw new ConfigurationException(this.notFoundExc.getMessage(), (Throwable)this.notFoundExc);
        }
        if (this.fromValue != null) {
            try {
                LOG.trace("Converting value: {}", this.fromValue);
                R converted = this.convert(this.fromValue);
                LOG.trace("Converted value: {}", converted);
                if (converted != null) {
                    return converted;
                }
            }
            catch (ConfigurationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
        throw new ConfigurationException("No value present.");
    }

    public R get(R defaultValue) {
        LOG.trace("Getting \"{}\" value.", (Object)this.name);
        if (this.fromValue != null && this.notFoundExc == null) {
            try {
                LOG.trace("Converting value: {}", this.fromValue);
                R converted = this.convert(this.fromValue);
                LOG.trace("Converted value: {}", converted);
                if (converted != null) {
                    return converted;
                }
            }
            catch (Exception e) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
        LOG.trace("Using default value: {}", defaultValue);
        return defaultValue;
    }

    protected abstract T fromConfig(ImmutableConfiguration var1, String var2) throws NoSuchElementException;

    protected abstract R convert(T var1) throws Exception;
}

