/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.config.converter;

import java.util.NoSuchElementException;
import net.savignano.uptrust.service.config.converter.StringConverter;
import net.savignano.uptrust.service.password.IPasswordDecoder;
import net.savignano.uptrust.service.password.IPasswordDecoderSupplier;
import org.apache.commons.configuration2.ImmutableConfiguration;

public class PasswordConverter
extends StringConverter<char[], PasswordConverter> {
    private IPasswordDecoder decoder;
    private IPasswordDecoderSupplier supplier;
    private String algorithm;

    public PasswordConverter() {
        super("Password");
    }

    public PasswordConverter useDecoder(IPasswordDecoder decoder) {
        this.decoder = decoder;
        return this;
    }

    public PasswordConverter withAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public PasswordConverter useDecoderSupplier(IPasswordDecoderSupplier supplier) {
        this.supplier = supplier;
        return this;
    }

    @Override
    protected String fromConfig(ImmutableConfiguration config, String key) throws NoSuchElementException {
        this.withAlgorithm(config.getString(key + "[@cipher]", null));
        return super.fromConfig(config, key);
    }

    @Override
    protected char[] convert(String value) throws Exception {
        if (this.decoder == null && this.supplier != null) {
            this.decoder = this.supplier.getDecoder(this.algorithm);
        }
        if (this.decoder != null) {
            return this.decoder.decode(value);
        }
        throw new NullPointerException("No decoder was supplied to decode password.");
    }
}

