/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.cryptography;

import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import javax.mail.Address;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.uptrust.service.EResult;
import net.savignano.uptrust.service.cryptography.ICryptographyService;

public interface IEncryptionService
extends ICryptographyService {
    default public EncryptionResult encrypt(MimeMessage msg, ECryptographyType cryptography) {
        return this.encrypt(msg, cryptography, null);
    }

    public EncryptionResult encrypt(MimeMessage var1, ECryptographyType var2, Collection<Address> var3);

    public static class EncryptionResult
    extends ICryptographyService.CryptographyResult {
        private final Map<EKeyValidity, Collection<Address>> validity = new EnumMap<EKeyValidity, Collection<Address>>(EKeyValidity.class);

        public Map<EKeyValidity, Collection<Address>> getValidity() {
            return this.validity;
        }

        @Override
        public EResult getResult() {
            if (super.getResult() != EResult.SUCCESS) {
                return super.getResult();
            }
            if (this.getValidity().size() != 1) {
                return EResult.UNDEFINED;
            }
            return this.getValidity().keySet().iterator().next() == EKeyValidity.VALID ? EResult.SUCCESS : EResult.FAILURE;
        }

        @Override
        protected Map<String, Object> getStringHelper() {
            Map<String, Object> map = super.getStringHelper();
            map.put("validity", this.getValidity());
            return map;
        }
    }
}

