/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.cryptography;

import java.util.Map;
import java.util.Optional;
import javax.mail.Address;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.uptrust.service.EResult;
import net.savignano.uptrust.service.cryptography.ICryptographyService;

public interface IExtractionService
extends ICryptographyService {
    public ExtractionResult extract(MimeMessage var1);

    public static class ExtractionResult
    extends ICryptographyService.CryptographyResult {
        private Optional<ICryptographyKey<?>> key = Optional.empty();
        private Address address;

        public Optional<ICryptographyKey<?>> getKey() {
            return this.key;
        }

        public void setKey(Optional<ICryptographyKey<?>> key) {
            this.key = key;
        }

        public void setKey(ICryptographyKey<?> key) {
            this.key = Optional.ofNullable(key);
        }

        public Address getAddress() {
            return this.address;
        }

        public void setAddress(Address address) {
            this.address = address;
        }

        @Override
        public EResult getResult() {
            if (this.getKey().isEmpty()) {
                return EResult.FAILURE;
            }
            return super.getResult();
        }

        @Override
        protected Map<String, Object> getStringHelper() {
            Map<String, Object> map = super.getStringHelper();
            map.put("key", this.getKey().orElse(null));
            return map;
        }
    }
}

