/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.cryptography;

import java.util.Map;
import javax.mail.Address;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.uptrust.service.EResult;
import net.savignano.uptrust.service.cryptography.ICryptographyService;

public interface ISigningService
extends ICryptographyService {
    public SigningResult sign(MimeMessage var1, ECryptographyType var2);

    public static class SigningResult
    extends ICryptographyService.CryptographyResult {
        private Address address;
        private EKeyValidity validity;

        public Address getAddress() {
            return this.address;
        }

        public void setAddress(Address address) {
            this.address = address;
        }

        public EKeyValidity getValidity() {
            return this.validity;
        }

        public void setValidity(EKeyValidity validity) {
            this.validity = validity;
        }

        @Override
        public EResult getResult() {
            if (this.getValidity() != EKeyValidity.VALID) {
                return EResult.FAILURE;
            }
            return super.getResult();
        }

        @Override
        protected Map<String, Object> getStringHelper() {
            Map<String, Object> map = super.getStringHelper();
            map.put("email", this.getAddress());
            map.put("validity", this.getValidity());
            return map;
        }
    }
}

