/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.cryptography;

import java.util.Map;
import java.util.Set;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.EValidationType;
import net.savignano.uptrust.service.EResult;
import net.savignano.uptrust.service.cryptography.ICryptographyService;

public interface IValidationService
extends ICryptographyService {
    public boolean isSigned(MimeMessage var1);

    public ValidationResult validate(MimeMessage var1);

    public static class ValidationResult
    extends ICryptographyService.CryptographyResult {
        private Set<EValidationType> actualValidations;
        private Set<EValidationType> expectedValidations;

        @Override
        public EResult getResult() {
            if (!this.isValid()) {
                return EResult.FAILURE;
            }
            return super.getResult();
        }

        public boolean isValid() {
            return this.getActualValidations().containsAll(this.getExpectedValidations());
        }

        public Set<EValidationType> getActualValidations() {
            return this.actualValidations;
        }

        public void setActualValidations(Set<EValidationType> actualValidations) {
            this.actualValidations = actualValidations;
        }

        public Set<EValidationType> getExpectedValidations() {
            return this.expectedValidations;
        }

        public void setExpectedValidations(Set<EValidationType> expectedValidations) {
            this.expectedValidations = expectedValidations;
        }

        @Override
        protected Map<String, Object> getStringHelper() {
            Map<String, Object> map = super.getStringHelper();
            map.put("actualValidations", this.getActualValidations());
            map.put("expectedValidations", this.getExpectedValidations());
            return map;
        }
    }
}

