/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.cryptography.config;

import javax.mail.Session;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.version.ProductInformation;
import net.savignano.uptrust.service.key.IKeyService;

public class CryptographyServiceConfiguration {
    private Session session;
    private ProductInformation productInfo;
    private IKeyService keyService;

    public CryptographyServiceConfiguration() {
    }

    public CryptographyServiceConfiguration(CryptographyServiceConfiguration config) {
        this.session = config.getSession();
        this.productInfo = config.getProductInfo();
        this.keyService = config.getKeyService();
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public ProductInformation getProductInfo() {
        return this.productInfo;
    }

    public void setProductInfo(ProductInformation productInfo) {
        this.productInfo = productInfo;
    }

    public IKeyService getKeyService() {
        return this.keyService;
    }

    public void setKeyService(IKeyService keyService) {
        this.keyService = keyService;
    }

    public static enum ECryptographyUsage {
        PGP_ONLY,
        PGP_PREFERRED,
        SMIME_ONLY,
        SMIME_PREFERRED;


        public ECryptographyType getCryptography() {
            switch (this) {
                case PGP_ONLY: 
                case PGP_PREFERRED: {
                    return ECryptographyType.PGP;
                }
                case SMIME_ONLY: 
                case SMIME_PREFERRED: {
                    return ECryptographyType.SMIME;
                }
            }
            throw new IllegalStateException("Unknown encryption type priority type encountered: " + String.valueOf((Object)this));
        }

        public ECryptographyType getFallbackCryptography() {
            switch (this) {
                case PGP_ONLY: 
                case SMIME_ONLY: {
                    return ECryptographyType.NONE;
                }
                case PGP_PREFERRED: {
                    return ECryptographyType.SMIME;
                }
                case SMIME_PREFERRED: {
                    return ECryptographyType.PGP;
                }
            }
            throw new IllegalStateException("Unknown encryption type priority type encountered: " + String.valueOf((Object)this));
        }
    }
}

