/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.cryptography.config;

import net.savignano.uptrust.service.cryptography.config.ACryptographicServiceBuilder;
import net.savignano.uptrust.service.cryptography.config.DecryptionServiceConfiguration;
import net.savignano.uptrust.service.cryptography.impl.DecryptionService;
import org.apache.commons.configuration2.ImmutableConfiguration;

public class DecryptionServiceBuilder
extends ACryptographicServiceBuilder<DecryptionService, DecryptionServiceConfiguration, DecryptionServiceBuilder> {
    private static final String PGP_CHECK_INLINE_KEY = "pgpCheckInline";
    private static final String PGP_BINARY_REGEX_KEY = "pgpBinaryRegex";

    public static final DecryptionServiceBuilder empty() {
        return new DecryptionServiceBuilder();
    }

    public static final DecryptionServiceBuilder from(ImmutableConfiguration config) {
        return DecryptionServiceBuilder.empty().pgpCheckInline(config.getBoolean(PGP_CHECK_INLINE_KEY, false)).pgpBinaryRegex(config.getString(PGP_BINARY_REGEX_KEY, null));
    }

    private DecryptionServiceBuilder() {
        super(new DecryptionServiceConfiguration());
    }

    @Override
    public DecryptionService build() {
        return new DecryptionService(this.getConfig());
    }

    @Override
    public DecryptionServiceConfiguration getConfig() {
        return new DecryptionServiceConfiguration((DecryptionServiceConfiguration)this.config);
    }

    public DecryptionServiceBuilder pgpCheckInline(boolean inline) {
        ((DecryptionServiceConfiguration)this.config).setPgpCheckInline(inline);
        return this;
    }

    public DecryptionServiceBuilder pgpBinaryRegex(String regex) {
        ((DecryptionServiceConfiguration)this.config).setPgpBinaryRegex(regex);
        return this;
    }
}

