/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.cryptography.config;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.uptrust.service.config.converter.SmimeAlgorithmConverter;
import net.savignano.uptrust.service.cryptography.config.ACryptographicServiceBuilder;
import net.savignano.uptrust.service.cryptography.config.EncryptionServiceConfiguration;
import net.savignano.uptrust.service.cryptography.impl.EncryptionService;
import org.apache.commons.configuration2.ImmutableConfiguration;

public class EncryptionServiceBuilder
extends ACryptographicServiceBuilder<EncryptionService, EncryptionServiceConfiguration, EncryptionServiceBuilder> {
    private static final String PGP_SYM_KEY_ALG_KEY = "pgpSymmetricKeyAlgorithm";
    private static final String SMIME_SYM_KEY_ALG_KEY = "smimeSymmetricKeyAlgorithm";
    private static final String SMIME_SYM_KEY_SIZE_KEY = "smimeSymmetricKeySize";

    public static final EncryptionServiceBuilder empty() {
        return new EncryptionServiceBuilder();
    }

    public static final EncryptionServiceBuilder from(ImmutableConfiguration config) {
        ASN1ObjectIdentifier smimeAlg = ((SmimeAlgorithmConverter)new SmimeAlgorithmConverter().from(config, SMIME_SYM_KEY_ALG_KEY)).get(null);
        return EncryptionServiceBuilder.empty().pgpSymmetricKeyAlgorithm(config.getInt(PGP_SYM_KEY_ALG_KEY, -1)).smimeSymmetricKeyAlgorithm(smimeAlg).smimeSymmetricKeySize(config.getInt(SMIME_SYM_KEY_SIZE_KEY, 0));
    }

    private EncryptionServiceBuilder() {
        super(new EncryptionServiceConfiguration());
    }

    @Override
    public EncryptionService build() {
        return new EncryptionService(this.getConfig());
    }

    @Override
    public EncryptionServiceConfiguration getConfig() {
        return new EncryptionServiceConfiguration((EncryptionServiceConfiguration)this.config);
    }

    public EncryptionServiceBuilder pgpSymmetricKeyAlgorithm(int algorithm) {
        ((EncryptionServiceConfiguration)this.config).setPgpSymmetricKeyAlgorithm(algorithm);
        return this;
    }

    public EncryptionServiceBuilder smimeSymmetricKeyAlgorithm(ASN1ObjectIdentifier algorithm) {
        ((EncryptionServiceConfiguration)this.config).setSmimeSymmetricKeyAlgorithm(algorithm);
        return this;
    }

    public EncryptionServiceBuilder smimeSymmetricKeySize(int size) {
        ((EncryptionServiceConfiguration)this.config).setSmimeSymmetricKeySize(size);
        return this;
    }
}

