/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.cryptography.config;

import java.security.cert.PKIXParameters;
import net.savignano.uptrust.service.cryptography.config.ACryptographicServiceBuilder;
import net.savignano.uptrust.service.cryptography.config.ValidationServiceConfiguration;
import net.savignano.uptrust.service.cryptography.impl.ValidationService;
import org.apache.commons.configuration2.ImmutableConfiguration;

public class ValidationServiceBuilder
extends ACryptographicServiceBuilder<ValidationService, ValidationServiceConfiguration, ValidationServiceBuilder> {
    private static final String PGP_CHECK_INLINE_KEY = "pgpCheckInline";

    public static final ValidationServiceBuilder empty() {
        return new ValidationServiceBuilder();
    }

    public static final ValidationServiceBuilder from(ImmutableConfiguration config) {
        return ValidationServiceBuilder.empty().pgpCheckInline(config.getBoolean(PGP_CHECK_INLINE_KEY, false));
    }

    private ValidationServiceBuilder() {
        super(new ValidationServiceConfiguration());
    }

    @Override
    public ValidationService build() {
        return new ValidationService(this.getConfig());
    }

    @Override
    public ValidationServiceConfiguration getConfig() {
        return new ValidationServiceConfiguration((ValidationServiceConfiguration)this.config);
    }

    public ValidationServiceBuilder pgpCheckInline(boolean inline) {
        ((ValidationServiceConfiguration)this.config).setPgpCheckInline(inline);
        return this;
    }

    public ValidationServiceBuilder smimePkix(PKIXParameters pkix) {
        ((ValidationServiceConfiguration)this.config).setSmimePkix(pkix);
        return this;
    }
}

