/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.cryptography.impl;

import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.uptrust.service.cryptography.ICryptographyService;
import net.savignano.uptrust.service.cryptography.config.CryptographyServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptographicService<R extends ICryptographyService.CryptographyResult, C extends CryptographyServiceConfiguration>
implements ICryptographyService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final C config;

    protected CryptographicService(C config) {
        this.config = config;
        if (config == null) {
            throw new IllegalAccessError("Configuration must not be null.");
        }
    }

    protected Logger getLog() {
        return this.log;
    }

    protected C getConfig() {
        return this.config;
    }

    protected <T extends ICryptographyKey<?>> T provideKey(Object keyFor, Class<T> keyType) {
        return ((CryptographyServiceConfiguration)this.getConfig()).getKeyService().getKey(keyFor, keyType);
    }
}

