/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.cryptography.impl;

import java.io.IOException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.key.ISecretCryptographyKey;
import net.savignano.cryptography.key.pgp.PgpDecryptionKey;
import net.savignano.cryptography.key.smime.SmimeDecryptionKey;
import net.savignano.cryptography.mail.IKeyProvider;
import net.savignano.cryptography.mail.decrypt.IMailDecryptor;
import net.savignano.cryptography.mail.decrypt.PgpMailDecryptor;
import net.savignano.cryptography.mail.decrypt.SmimeMailDecryptor;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.thirdparty.org.bouncycastle.cms.KeyTransRecipientId;
import net.savignano.uptrust.service.cryptography.IDecryptionService;
import net.savignano.uptrust.service.cryptography.config.DecryptionServiceConfiguration;
import net.savignano.uptrust.service.cryptography.impl.CryptographicService;

public class DecryptionService
extends CryptographicService<IDecryptionService.DecryptionResult, DecryptionServiceConfiguration>
implements IDecryptionService {
    private PgpMailDecryptor pgpDecryptor;
    private SmimeMailDecryptor smimeDecryptor;

    public DecryptionService(DecryptionServiceConfiguration config) {
        super(config);
    }

    @Override
    public boolean isEncrypted(MimeMessage msg) {
        try {
            return this.isSmimeEncrypted(msg) || this.isPgpEncrypted(msg);
        }
        catch (Exception e) {
            this.getLog().error("Could not check whether message with ID \"" + MessageUtil.getMessageId((Message)msg) + "\" is encrypted. Error message: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public IDecryptionService.DecryptionResult decrypt(MimeMessage msg) {
        String msgId = MessageUtil.getMessageId((Message)msg);
        this.getLog().debug("Decrypting message with ID \"{}\".", (Object)msgId);
        IDecryptionService.DecryptionResult result = new IDecryptionService.DecryptionResult();
        result.setMessage(msg);
        try {
            if (this.isSmimeEncrypted(msg)) {
                this.decryptSmime(result);
            } else if (this.isPgpEncrypted(msg)) {
                this.decryptPgp(result);
            }
        }
        catch (Exception e) {
            this.getLog().error("Could not decrypt message with ID \"" + msgId + "\". Error message: " + e.getMessage(), (Throwable)e);
            result.setException(e);
        }
        if (result.getCryptography() == null) {
            result.setCryptography(ECryptographyType.NONE);
        }
        this.getLog().debug("Decryption result for message with ID \"{}\": {}", (Object)msgId, (Object)result);
        return result;
    }

    private boolean isPgpEncrypted(MimeMessage msg) throws IOException, MessagingException {
        return this.isEncrypted(msg, (IMailDecryptor<?, ?>)this.getPgpDecryptor());
    }

    private void decryptPgp(IDecryptionService.DecryptionResult result) throws IOException, MessagingException {
        this.decrypt(result, (IMailDecryptor)this.getPgpDecryptor(), (IKeyProvider)this::providePgpDecryptionKey, ECryptographyType.PGP);
        result.setPreferredCryptography(this.getPgpDecryptor().isPreferredAlgorithmUsed());
    }

    private PgpMailDecryptor getPgpDecryptor() {
        if (this.pgpDecryptor == null) {
            this.pgpDecryptor = this.createPgpDecryptor();
        }
        return this.pgpDecryptor;
    }

    private PgpMailDecryptor createPgpDecryptor() {
        PgpMailDecryptor decryptor = new PgpMailDecryptor(((DecryptionServiceConfiguration)this.getConfig()).getSession());
        decryptor.setProductInfo(((DecryptionServiceConfiguration)this.getConfig()).getProductInfo());
        decryptor.setCheckInline(((DecryptionServiceConfiguration)this.getConfig()).isPgpCheckInline());
        decryptor.setBinaryRegex(((DecryptionServiceConfiguration)this.getConfig()).getPgpBinaryRegex());
        return decryptor;
    }

    private PgpDecryptionKey providePgpDecryptionKey(Long id) {
        return this.provideKey(id, PgpDecryptionKey.class);
    }

    private boolean isSmimeEncrypted(MimeMessage msg) throws IOException, MessagingException {
        return this.isEncrypted(msg, (IMailDecryptor<?, ?>)this.getSmimeDecryptor());
    }

    private void decryptSmime(IDecryptionService.DecryptionResult result) throws IOException, MessagingException {
        this.decrypt(result, (IMailDecryptor)this.getSmimeDecryptor(), (IKeyProvider)this::provideSmimeDecryptionKey, ECryptographyType.SMIME);
        result.setPreferredCryptography(true);
    }

    private SmimeMailDecryptor getSmimeDecryptor() {
        if (this.smimeDecryptor == null) {
            this.smimeDecryptor = this.createSmimeDecryptor();
        }
        return this.smimeDecryptor;
    }

    private SmimeMailDecryptor createSmimeDecryptor() {
        SmimeMailDecryptor decryptor = new SmimeMailDecryptor(((DecryptionServiceConfiguration)this.getConfig()).getSession());
        decryptor.setProductInfo(((DecryptionServiceConfiguration)this.getConfig()).getProductInfo());
        return decryptor;
    }

    private SmimeDecryptionKey provideSmimeDecryptionKey(KeyTransRecipientId id) {
        return this.provideKey(id, SmimeDecryptionKey.class);
    }

    private boolean isEncrypted(MimeMessage msg, IMailDecryptor<?, ?> decryptor) throws IOException, MessagingException {
        return decryptor.isEncrypted(msg);
    }

    private <T extends ISecretCryptographyKey<?>, U> void decrypt(IDecryptionService.DecryptionResult result, IMailDecryptor<T, U> decryptor, IKeyProvider<U, T> key, ECryptographyType cryptography) throws IOException, MessagingException {
        result.setCryptography(cryptography);
        this.getLog().debug("Decrypting {} message with ID \"{}\".", (Object)cryptography, (Object)MessageUtil.getMessageId((Message)result.getMessage()));
        decryptor.decryptMessage(result.getMessage(), key);
    }
}

