/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.cryptography.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.LazyLog;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.key.IPublicCryptographyKey;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;
import net.savignano.cryptography.mail.encrypt.IEncryptionResult;
import net.savignano.cryptography.mail.encrypt.IMailEncryptor;
import net.savignano.cryptography.mail.encrypt.PgpMailEncryptor;
import net.savignano.cryptography.mail.encrypt.SmimeMailEncryptor;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.uptrust.service.cryptography.IEncryptionService;
import net.savignano.uptrust.service.cryptography.config.EncryptionServiceConfiguration;
import net.savignano.uptrust.service.cryptography.impl.CryptographicService;

public class EncryptionService
extends CryptographicService<IEncryptionService.EncryptionResult, EncryptionServiceConfiguration>
implements IEncryptionService {
    private PgpMailEncryptor pgpEncryptor;
    private SmimeMailEncryptor smimeEncryptor;

    public EncryptionService(EncryptionServiceConfiguration config) {
        super(config);
    }

    @Override
    public IEncryptionService.EncryptionResult encrypt(MimeMessage msg, ECryptographyType cryptography, Collection<Address> addresses) {
        String msgId = MessageUtil.getMessageId((Message)msg);
        this.getLog().debug("Encrypting {} message with ID \"{}\".", (Object)cryptography, (Object)msgId);
        IEncryptionService.EncryptionResult result = new IEncryptionService.EncryptionResult();
        result.setMessage(msg);
        switch (cryptography) {
            case PGP: {
                this.encryptPgp(result, addresses != null ? addresses : this.getAddressesFromMsg(msg));
                break;
            }
            case SMIME: {
                this.encryptSmime(result, addresses != null ? addresses : this.getAddressesFromMsg(msg));
                break;
            }
            case NONE: {
                this.getLog().info("Message with ID \"{}\" should explicitly not get encrypted.", (Object)msgId);
                break;
            }
            default: {
                this.getLog().error("Unknown cryptography encountered. Message with ID \"{]\" will not be encrypted. Argument: {}", (Object)msgId, (Object)cryptography);
            }
        }
        this.getLog().debug("Encryption result for message with ID \"{}\": {}", (Object)msgId, (Object)result);
        return result;
    }

    private void encryptPgp(IEncryptionService.EncryptionResult result, Collection<Address> addresses) {
        this.encrypt(result, (IMailEncryptor)this.getPgpEncryptor(), (Function)this::providePgpEncryptionKey, addresses);
    }

    private PgpMailEncryptor getPgpEncryptor() {
        if (this.pgpEncryptor == null) {
            this.pgpEncryptor = this.createPgpEncryptor();
        }
        return this.pgpEncryptor;
    }

    private PgpMailEncryptor createPgpEncryptor() {
        PgpMailEncryptor encryptor = new PgpMailEncryptor(((EncryptionServiceConfiguration)this.getConfig()).getSession());
        encryptor.setProductInfo(((EncryptionServiceConfiguration)this.getConfig()).getProductInfo());
        if (((EncryptionServiceConfiguration)this.getConfig()).getPgpSymmetricKeyAlgorithm() != -1) {
            encryptor.setForceSymmetricKeyAlgorithm(((EncryptionServiceConfiguration)this.getConfig()).getPgpSymmetricKeyAlgorithm());
        }
        return encryptor;
    }

    private PgpEncryptionKey providePgpEncryptionKey(String email) {
        return this.provideKey(email, PgpEncryptionKey.class);
    }

    private void encryptSmime(IEncryptionService.EncryptionResult result, Collection<Address> addresses) {
        this.encrypt(result, (IMailEncryptor)this.getSmimeEncryptor(), (Function)this::provideSmimeEncryptionKey, addresses);
    }

    private SmimeMailEncryptor getSmimeEncryptor() {
        if (this.smimeEncryptor == null) {
            this.smimeEncryptor = this.createSmimeEncryptor();
        }
        return this.smimeEncryptor;
    }

    private SmimeMailEncryptor createSmimeEncryptor() {
        SmimeMailEncryptor encryptor = new SmimeMailEncryptor(((EncryptionServiceConfiguration)this.getConfig()).getSession());
        encryptor.setProductInfo(((EncryptionServiceConfiguration)this.getConfig()).getProductInfo());
        if (((EncryptionServiceConfiguration)this.getConfig()).getSmimeSymmetricKeyAlgorithm() != null) {
            encryptor.setForceSymmetricKeyAlgorithm(((EncryptionServiceConfiguration)this.getConfig()).getSmimeSymmetricKeyAlgorithm());
            encryptor.setForceSymmetricKeySize(((EncryptionServiceConfiguration)this.getConfig()).getSmimeSymmetricKeySize());
        }
        return encryptor;
    }

    private SmimeEncryptionKey provideSmimeEncryptionKey(String email) {
        return this.provideKey(email, SmimeEncryptionKey.class);
    }

    private <T extends IPublicCryptographyKey<?>, U, R extends IEncryptionResult> void encrypt(IEncryptionService.EncryptionResult result, IMailEncryptor<T, R> encryptor, Function<String, T> keyFunction, Collection<Address> addresses) {
        Collection<T> keys = this.getEncryptionKeys(result, addresses, keyFunction);
        IEncryptionResult encResult = encryptor.encryptMessage(result.getMessage(), keys);
        result.setCryptography(encResult.getCryptography());
        result.setException(encResult.getException());
    }

    private <T extends IPublicCryptographyKey<?>> Collection<T> getEncryptionKeys(IEncryptionService.EncryptionResult result, Collection<Address> addresses, Function<String, T> keyFunction) {
        this.getLog().debug("Looking up encryption keys for addresses: {}", addresses);
        ArrayList<IPublicCryptographyKey> validKeys = new ArrayList<IPublicCryptographyKey>(addresses.size());
        for (Address address : addresses) {
            Collection<Address> emails;
            IPublicCryptographyKey key = (IPublicCryptographyKey)keyFunction.apply(MessageUtil.getEmail((Address)address));
            if (key.isValid()) {
                validKeys.add(key);
            }
            if ((emails = result.getValidity().get(key.getKeyValidity())) == null) {
                emails = new ArrayList<Address>();
                result.getValidity().put(key.getKeyValidity(), emails);
            }
            emails.add(address);
        }
        return validKeys;
    }

    private Collection<Address> getAddressesFromMsg(MimeMessage msg) {
        HashSet<Address> addresses = new HashSet<Address>();
        try {
            addresses.addAll(Arrays.asList(msg.getAllRecipients()));
        }
        catch (MessagingException e) {
            this.getLog().error("Could not retrieve recipients from message with ID \"" + MessageUtil.getMessageId((Message)msg) + "\". Error message: " + e.getMessage(), (Throwable)e);
        }
        try {
            Address[] from = msg.getFrom();
            if (from != null) {
                addresses.addAll(Arrays.asList(from));
            }
        }
        catch (MessagingException e) {
            this.getLog().error("Could not retrieve sender from message with ID \"" + MessageUtil.getMessageId((Message)msg) + "\". Error message: " + e.getMessage(), (Throwable)e);
        }
        this.getLog().debug("Extracted addresses from message with ID \"{}\": {}", (Object)new LazyLog(() -> MessageUtil.getMessageId((Message)msg)), addresses);
        return addresses;
    }
}

