/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.cryptography.impl;

import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;
import net.savignano.cryptography.mail.visitor.extract.PgpMailExtractor;
import net.savignano.cryptography.mail.visitor.extract.SmimeMailExtractor;
import net.savignano.cryptography.mail.visitor.specific.DetectCryptographyVisitor;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.uptrust.service.cryptography.IExtractionService;
import net.savignano.uptrust.service.cryptography.config.ExtractionServiceConfiguration;
import net.savignano.uptrust.service.cryptography.impl.CryptographicService;

public class ExtractionService
extends CryptographicService<IExtractionService.ExtractionResult, ExtractionServiceConfiguration>
implements IExtractionService {
    public ExtractionService(ExtractionServiceConfiguration config) {
        super(config);
    }

    @Override
    public IExtractionService.ExtractionResult extract(MimeMessage msg) {
        IExtractionService.ExtractionResult result = new IExtractionService.ExtractionResult();
        if (msg == null) {
            result.setCryptography(ECryptographyType.NONE);
            return result;
        }
        result.setMessage(msg);
        this.getLog().debug("Extracting keys from message with ID \"{}\".", (Object)result.getMessageId());
        result.setAddress(MessageUtil.getFrom((MimeMessage)msg).orElse(null));
        DetectCryptographyVisitor visitor = new DetectCryptographyVisitor();
        try {
            visitor.visit(result.getMessage());
            switch ((ECryptographyType)visitor.getResult()) {
                case PGP: {
                    this.extractPgp(result);
                    break;
                }
                case SMIME: {
                    this.extractSmime(result);
                    break;
                }
                default: {
                    result.setCryptography(ECryptographyType.NONE);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.getLog().error("Could not extract key from message with ID \"" + result.getMessageId() + "\".", (Throwable)e);
            result.setException(e);
        }
        if (result.getCryptography() == null) {
            result.setCryptography(ECryptographyType.NONE);
        }
        this.getLog().debug("Extraction result for message with ID \"{}\": {}", (Object)result.getMessageId(), (Object)result);
        return result;
    }

    private void extractPgp(IExtractionService.ExtractionResult result) {
        PgpMailExtractor extractor = new PgpMailExtractor(((ExtractionServiceConfiguration)this.getConfig()).getSession());
        extractor.setProductInfo(((ExtractionServiceConfiguration)this.getConfig()).getProductInfo());
        PgpEncryptionKey key = (PgpEncryptionKey)extractor.extractPublicKey(result.getMessage());
        if (key.isValid()) {
            result.setKey((ICryptographyKey<?>)key);
            result.setCryptography(ECryptographyType.PGP);
        }
    }

    private void extractSmime(IExtractionService.ExtractionResult result) {
        SmimeMailExtractor extractor = new SmimeMailExtractor(((ExtractionServiceConfiguration)this.getConfig()).getSession());
        extractor.setProductInfo(((ExtractionServiceConfiguration)this.getConfig()).getProductInfo());
        SmimeEncryptionKey key = (SmimeEncryptionKey)extractor.extractPublicKey(result.getMessage());
        if (key.isValid()) {
            result.setKey((ICryptographyKey<?>)key);
            result.setCryptography(ECryptographyType.SMIME);
        }
    }
}

