/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.cryptography.impl;

import java.util.function.Function;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.ISecretCryptographyKey;
import net.savignano.cryptography.key.pgp.PgpSignKey;
import net.savignano.cryptography.key.smime.SmimeSignKey;
import net.savignano.cryptography.mail.sign.IMailSigner;
import net.savignano.cryptography.mail.sign.ISigningResult;
import net.savignano.cryptography.mail.sign.PgpMailSigner;
import net.savignano.cryptography.mail.sign.SmimeMailSigner;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.uptrust.service.cryptography.ISigningService;
import net.savignano.uptrust.service.cryptography.config.SigningServiceConfiguration;
import net.savignano.uptrust.service.cryptography.impl.CryptographicService;

public class SigningService
extends CryptographicService<ISigningService.SigningResult, SigningServiceConfiguration>
implements ISigningService {
    private PgpMailSigner pgpSigner;
    private SmimeMailSigner smimeSigner;

    public SigningService(SigningServiceConfiguration config) {
        super(config);
    }

    @Override
    public ISigningService.SigningResult sign(MimeMessage msg, ECryptographyType cryptography) {
        String msgId = MessageUtil.getMessageId((Message)msg);
        this.getLog().debug("Signing {} message with ID \"{}\".", (Object)cryptography, (Object)msgId);
        ISigningService.SigningResult result = new ISigningService.SigningResult();
        result.setMessage(msg);
        switch (cryptography) {
            case PGP: {
                this.signPgp(result);
                break;
            }
            case SMIME: {
                this.signSmime(result);
                break;
            }
            case NONE: {
                this.getLog().debug("Message was explicitly not signed.");
                break;
            }
            default: {
                this.getLog().error("Unknown cryptography encountered. Message will not be signed. Usage: {}", (Object)cryptography);
            }
        }
        this.getLog().debug("Signing result for message with ID \"{}\": {}", (Object)msgId, (Object)result);
        return result;
    }

    private void signPgp(ISigningService.SigningResult result) {
        this.sign(result, (IMailSigner)this.getPgpSigner(), (Function)this::providePgpSignKey);
    }

    private PgpMailSigner getPgpSigner() {
        if (this.pgpSigner == null) {
            this.pgpSigner = this.createPgpSigner();
        }
        return this.pgpSigner;
    }

    private PgpMailSigner createPgpSigner() {
        PgpMailSigner signer = new PgpMailSigner(((SigningServiceConfiguration)this.getConfig()).getSession());
        signer.setProductInfo(((SigningServiceConfiguration)this.getConfig()).getProductInfo());
        return signer;
    }

    private PgpSignKey providePgpSignKey(String email) {
        return this.provideKey(email, PgpSignKey.class);
    }

    private void signSmime(ISigningService.SigningResult result) {
        this.sign(result, (IMailSigner)this.getSmimeSigner(), (Function)this::provideSmimeSignKey);
    }

    private SmimeMailSigner getSmimeSigner() {
        if (this.smimeSigner == null) {
            this.smimeSigner = this.createSmimeSigner();
        }
        return this.smimeSigner;
    }

    private SmimeMailSigner createSmimeSigner() {
        SmimeMailSigner signer = new SmimeMailSigner(((SigningServiceConfiguration)this.getConfig()).getSession());
        signer.setProductInfo(((SigningServiceConfiguration)this.getConfig()).getProductInfo());
        return signer;
    }

    private SmimeSignKey provideSmimeSignKey(String email) {
        return this.provideKey(email, SmimeSignKey.class);
    }

    private <T extends ISecretCryptographyKey<?>> void sign(ISigningService.SigningResult result, IMailSigner<T, ? extends ISigningResult> signer, Function<String, T> keyProvider) {
        MimeMessage msg = result.getMessage();
        Address address = this.getAddress(msg);
        if (address == null) {
            result.setValidity(EKeyValidity.ERROR);
            result.setException((Exception)((Object)new MessagingException("Could not determine sender of message of with ID \"" + MessageUtil.getMessageId((Message)msg) + "\".")));
            return;
        }
        result.setAddress(address);
        ISecretCryptographyKey key = (ISecretCryptographyKey)keyProvider.apply(MessageUtil.getEmail((Address)address));
        result.setValidity(key.getKeyValidity());
        if (!key.isValid()) {
            return;
        }
        ISigningResult signResult = signer.sign(msg, key);
        result.setCryptography(signResult.getCryptography());
        result.setException(signResult.getException());
    }

    private Address getAddress(MimeMessage msg) {
        return MessageUtil.getFrom((MimeMessage)msg).orElse(null);
    }
}

