/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.cryptography.impl;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EValidationType;
import net.savignano.cryptography.key.pgp.PgpValidationKey;
import net.savignano.cryptography.mail.validate.IMailValidator;
import net.savignano.cryptography.mail.validate.PgpMailValidator;
import net.savignano.cryptography.mail.validate.SmimeMailValidator;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.uptrust.service.cryptography.IValidationService;
import net.savignano.uptrust.service.cryptography.config.ValidationServiceConfiguration;
import net.savignano.uptrust.service.cryptography.impl.CryptographicService;

public class ValidationService
extends CryptographicService<IValidationService.ValidationResult, ValidationServiceConfiguration>
implements IValidationService {
    private PgpMailValidator pgpValidator;
    private SmimeMailValidator smimeValidator;

    public ValidationService(ValidationServiceConfiguration config) {
        super(config);
    }

    @Override
    public boolean isSigned(MimeMessage msg) {
        try {
            return this.isSmimeSigned(msg) || this.isPgpSigned(msg);
        }
        catch (Exception e) {
            this.getLog().error("Could not check whether message with ID \"" + MessageUtil.getMessageId((Message)msg) + "\" is signed. Error message: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public IValidationService.ValidationResult validate(MimeMessage msg) {
        String msgId = MessageUtil.getMessageId((Message)msg);
        this.getLog().debug("Validating message with ID \"{}\".", (Object)msgId);
        IValidationService.ValidationResult result = new IValidationService.ValidationResult();
        result.setMessage(msg);
        try {
            if (this.isSmimeSigned(msg)) {
                this.validateSmime(result);
            } else if (this.isPgpSigned(msg)) {
                this.validatePgp(result);
            }
        }
        catch (Exception e) {
            this.getLog().error("Could not validate message with ID \"" + msgId + "\". Error message: " + e.getMessage(), (Throwable)e);
            result.setException(e);
        }
        if (result.getCryptography() == null) {
            result.setCryptography(ECryptographyType.NONE);
        }
        if (result.getActualValidations() == null) {
            result.setActualValidations(EnumSet.noneOf(EValidationType.class));
        }
        if (result.getExpectedValidations() == null) {
            result.setExpectedValidations(EnumSet.noneOf(EValidationType.class));
        }
        this.getLog().debug("Validation result for message with ID \"{}\": {}", (Object)msgId, (Object)result);
        return result;
    }

    private boolean isPgpSigned(MimeMessage msg) throws IOException, MessagingException {
        return this.isSigned(msg, (IMailValidator<?>)this.getPgpValidator());
    }

    private void validatePgp(IValidationService.ValidationResult result) throws IOException, MessagingException {
        this.validate(result, (IMailValidator<?>)this.getPgpValidator(), ECryptographyType.PGP);
    }

    private PgpMailValidator getPgpValidator() {
        if (this.pgpValidator == null) {
            this.pgpValidator = this.createPgpValidator();
        }
        return this.pgpValidator;
    }

    private PgpMailValidator createPgpValidator() {
        PgpMailValidator validator = new PgpMailValidator(((ValidationServiceConfiguration)this.getConfig()).getSession());
        validator.setProductInfo(((ValidationServiceConfiguration)this.getConfig()).getProductInfo());
        validator.setCheckInline(((ValidationServiceConfiguration)this.getConfig()).isPgpCheckInline());
        validator.setValidationKeyRetriever(this::providePgpValidationKey);
        return validator;
    }

    private PgpValidationKey providePgpValidationKey(Long id) {
        return this.provideKey(id, PgpValidationKey.class);
    }

    private boolean isSmimeSigned(MimeMessage msg) throws IOException, MessagingException {
        return this.isSigned(msg, (IMailValidator<?>)this.getSmimeValidator());
    }

    private void validateSmime(IValidationService.ValidationResult result) throws IOException, MessagingException {
        this.validate(result, (IMailValidator<?>)this.getSmimeValidator(), ECryptographyType.SMIME);
    }

    private SmimeMailValidator getSmimeValidator() {
        if (this.smimeValidator == null) {
            this.smimeValidator = this.createSmimeValidator();
        }
        return this.smimeValidator;
    }

    private SmimeMailValidator createSmimeValidator() {
        SmimeMailValidator validator = new SmimeMailValidator(((ValidationServiceConfiguration)this.getConfig()).getSession(), ((ValidationServiceConfiguration)this.getConfig()).getSmimePkix());
        validator.setProductInfo(((ValidationServiceConfiguration)this.getConfig()).getProductInfo());
        return validator;
    }

    private boolean isSigned(MimeMessage msg, IMailValidator<?> validator) throws IOException, MessagingException {
        return validator.isSigned(msg);
    }

    private void validate(IValidationService.ValidationResult result, IMailValidator<?> validator, ECryptographyType cryptography) throws IOException, MessagingException {
        result.setCryptography(cryptography);
        result.setExpectedValidations(validator.getValidationCapability());
        Set validations = validator.validate(result.getMessage());
        result.setActualValidations(validations);
    }
}

