/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.decoration;

import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.uptrust.service.decoration.IDecoration;

public class CryptographyDecoration
implements IDecoration {
    private final ECryptographyType cryptography;

    public CryptographyDecoration(ECryptographyType cryptography) {
        this.cryptography = cryptography;
        if (cryptography == null) {
            throw new IllegalArgumentException("Cryptography must not be null.");
        }
    }

    @Override
    public String buildHtml() {
        return this.asSuperscript(this.buildText());
    }

    @Override
    public String buildText() {
        switch (this.cryptography) {
            case NONE: {
                return "No Protection";
            }
        }
        return this.cryptography.toString();
    }

    private String asSuperscript(String text) {
        return "<sup>" + text + "</sup>";
    }

    public String toString() {
        return this.cryptography.toString();
    }
}

