/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.decoration;

import java.net.URL;
import java.util.EnumMap;
import java.util.Map;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.uptrust.service.decoration.CryptographyDecoration;
import net.savignano.uptrust.service.decoration.IDecoration;
import net.savignano.uptrust.service.decoration.ImageDecoration;
import net.savignano.uptrust.service.decorator.IDecoratorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecorationFactory {
    private static DecorationFactory factory;
    private final Map<IDecoratorService.EDecoration, IDecoration> decorations;
    private Logger log = null;

    public static final DecorationFactory get() {
        if (factory == null) {
            factory = new DecorationFactory();
        }
        return factory;
    }

    private DecorationFactory() {
        this.decorations = this.createMapping();
    }

    private Map<IDecoratorService.EDecoration, IDecoration> createMapping() {
        EnumMap<IDecoratorService.EDecoration, IDecoration> map = new EnumMap<IDecoratorService.EDecoration, IDecoration>(IDecoratorService.EDecoration.class);
        map.put(IDecoratorService.EDecoration.SMIME, this.createCryptoDeco(ECryptographyType.SMIME));
        map.put(IDecoratorService.EDecoration.PGP, this.createCryptoDeco(ECryptographyType.PGP));
        map.put(IDecoratorService.EDecoration.NO_CRYPTOGRAPHY, this.createCryptoDeco(ECryptographyType.NONE));
        map.put(IDecoratorService.EDecoration.SIGNED, this.createImgDeco("signed.png", "SIG OK"));
        map.put(IDecoratorService.EDecoration.SIGNED_FAILURE, this.createImgDeco("signed-mismatch.png", "SIG FAIL"));
        map.put(IDecoratorService.EDecoration.SIGNED_MISMATCH, this.createImgDeco("signed-mismatch.png", "SIG ERR"));
        map.put(IDecoratorService.EDecoration.SIGNED_UNVERIFIED, this.createImgDeco("signed-unverified.gif", "SIG UNV"));
        map.put(IDecoratorService.EDecoration.NOT_SIGNED, this.createImgDeco("not-signed.png", "NO SIG"));
        map.put(IDecoratorService.EDecoration.ENCRYPTED, this.createImgDeco("signed.png", "ENC OK"));
        map.put(IDecoratorService.EDecoration.ENCRYPTED_FAILURE, this.createImgDeco("encrypted-failure.png", "ENC FAIL"));
        map.put(IDecoratorService.EDecoration.ENCRYPTED_UNKNOWN, this.createImgDeco("encrypted-unknown.png", "ENC ??"));
        map.put(IDecoratorService.EDecoration.NOT_ENCRYPTED, this.createImgDeco("not-signed.png", "NO ENC"));
        return map;
    }

    private IDecoration createCryptoDeco(ECryptographyType crypto) {
        this.log.debug("Creating decoration for cryptography: {}", (Object)crypto);
        return new CryptographyDecoration(crypto);
    }

    private IDecoration createImgDeco(String resource, String title) {
        this.log.debug("Getting URL for decoration resource: {}", (Object)resource);
        URL url = this.getClass().getResource("/decoratorImgs/" + resource);
        this.log.debug("URL for decoration \"{}\": {}", (Object)title, (Object)resource);
        return new ImageDecoration(url, title);
    }

    public IDecoration create(IDecoratorService.EDecoration deco) {
        IDecoration decoration = this.decorations.get((Object)deco);
        if (decoration != null) {
            return decoration;
        }
        LoggerFactory.getLogger(this.getClass()).warn("Unknown decoration encountered: {}", (Object)deco);
        return new IDecoration(){

            @Override
            public String buildText() {
                return "";
            }

            @Override
            public String buildHtml() {
                return "";
            }
        };
    }
}

