/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.decoration;

import java.io.IOException;
import java.net.URL;
import java.util.Base64;
import net.savignano.uptrust.service.decoration.IDecoration;
import org.apache.commons.io.IOUtils;
import org.slf4j.LoggerFactory;

public class ImageDecoration
implements IDecoration {
    private final URL imageUrl;
    private final String altTitle;
    private boolean init;
    private String encodedImage;

    public ImageDecoration(URL imageUrl, String altTitle) {
        this.imageUrl = imageUrl;
        this.altTitle = altTitle == null ? "N/A" : altTitle;
    }

    @Override
    public String buildHtml() {
        String image = this.getEncodedImage();
        return image == null ? this.buildText(this.altTitle) : this.buildImage(image, this.altTitle);
    }

    @Override
    public String buildText() {
        return this.altTitle;
    }

    private String buildImage(String image, String altTitle) {
        StringBuilder builder = new StringBuilder(image.length() + 200);
        builder.append("<img src=\"data:image/png;base64,");
        builder.append(image);
        builder.append("\" alt=\"");
        builder.append(altTitle);
        builder.append("\" width=\"24\" height=\"24\">");
        return builder.toString();
    }

    private String buildText(String altTitle) {
        return "<sup>" + altTitle + "</sup>";
    }

    private String getEncodedImage() {
        if (!this.init) {
            this.init = true;
            try {
                this.encodedImage = this.encodeImage(this.loadImage(this.imageUrl));
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("Could not read image from \"" + String.valueOf(this.imageUrl) + "\". Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        return this.encodedImage;
    }

    private byte[] loadImage(URL url) throws IOException {
        return IOUtils.toByteArray((URL)url);
    }

    private String encodeImage(byte[] image) {
        return Base64.getEncoder().encodeToString(image);
    }

    public String toString() {
        return this.altTitle;
    }
}

