/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.decorator;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.uptrust.service.decoration.DecorationFactory;
import net.savignano.uptrust.service.decoration.IDecoration;
import net.savignano.uptrust.service.decorator.DecoratorServiceConfiguration;
import net.savignano.uptrust.service.decorator.IDecoratorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoratorService
implements IDecoratorService {
    private static final Logger LOG = LoggerFactory.getLogger(DecoratorService.class);
    private static final Map<IDecoratorService.EDecoration, Integer> CRYPTO_PRIO = DecoratorService.createCryptoPrio();
    private static final Map<IDecoratorService.EDecoration, Integer> SIGNED_PRIO = DecoratorService.createSignedPrio();
    private static final Map<IDecoratorService.EDecoration, Integer> ENCRYPTED_PRIO = DecoratorService.createEncryptedPrio();
    private static final Map<IDecoratorService.EDecoration, Integer> ORDERING = DecoratorService.createOrdering();
    private static final Set<IDecoratorService.EDecoration> PROTECTION_EXISTING = DecoratorService.createProtectionExisting();
    private static final Set<IDecoratorService.EDecoration> DECRYPTION_FAILED = DecoratorService.createDecryptionFailed();
    private final DecoratorServiceConfiguration config;

    private static final Map<IDecoratorService.EDecoration, Integer> createCryptoPrio() {
        EnumMap<IDecoratorService.EDecoration, Integer> map = new EnumMap<IDecoratorService.EDecoration, Integer>(IDecoratorService.EDecoration.class);
        map.put(IDecoratorService.EDecoration.SMIME, 0);
        map.put(IDecoratorService.EDecoration.PGP, 1);
        map.put(IDecoratorService.EDecoration.NO_CRYPTOGRAPHY, 2);
        return map;
    }

    private static final Map<IDecoratorService.EDecoration, Integer> createEncryptedPrio() {
        EnumMap<IDecoratorService.EDecoration, Integer> map = new EnumMap<IDecoratorService.EDecoration, Integer>(IDecoratorService.EDecoration.class);
        map.put(IDecoratorService.EDecoration.ENCRYPTED_FAILURE, 10);
        map.put(IDecoratorService.EDecoration.ENCRYPTED_UNKNOWN, 11);
        map.put(IDecoratorService.EDecoration.ENCRYPTED, 12);
        map.put(IDecoratorService.EDecoration.NOT_ENCRYPTED, 13);
        return map;
    }

    private static final Map<IDecoratorService.EDecoration, Integer> createSignedPrio() {
        EnumMap<IDecoratorService.EDecoration, Integer> map = new EnumMap<IDecoratorService.EDecoration, Integer>(IDecoratorService.EDecoration.class);
        map.put(IDecoratorService.EDecoration.SIGNED_FAILURE, 20);
        map.put(IDecoratorService.EDecoration.SIGNED_MISMATCH, 21);
        map.put(IDecoratorService.EDecoration.SIGNED_UNVERIFIED, 22);
        map.put(IDecoratorService.EDecoration.SIGNED, 23);
        map.put(IDecoratorService.EDecoration.NOT_SIGNED, 24);
        return map;
    }

    private static final Map<IDecoratorService.EDecoration, Integer> createOrdering() {
        EnumMap<IDecoratorService.EDecoration, Integer> map = new EnumMap<IDecoratorService.EDecoration, Integer>(IDecoratorService.EDecoration.class);
        map.putAll(CRYPTO_PRIO);
        map.putAll(ENCRYPTED_PRIO);
        map.putAll(SIGNED_PRIO);
        return map;
    }

    private static final Set<IDecoratorService.EDecoration> createProtectionExisting() {
        return EnumSet.complementOf(EnumSet.of(IDecoratorService.EDecoration.NO_CRYPTOGRAPHY, IDecoratorService.EDecoration.NOT_ENCRYPTED, IDecoratorService.EDecoration.NOT_SIGNED));
    }

    private static final Set<IDecoratorService.EDecoration> createDecryptionFailed() {
        return EnumSet.of(IDecoratorService.EDecoration.ENCRYPTED_UNKNOWN, IDecoratorService.EDecoration.ENCRYPTED_FAILURE);
    }

    protected DecoratorService(DecoratorServiceConfiguration config) {
        this.config = config;
        if (config == null) {
            throw new IllegalAccessError("Configuration must not be null.");
        }
    }

    @Override
    public IDecoratorService.DecorationResult decorate(MimeMessage msg, Iterable<IDecoratorService.EDecoration> decorations) {
        IDecoratorService.DecorationResult result = new IDecoratorService.DecorationResult();
        result.setMessage(msg);
        if (msg == null || decorations == null) {
            String errorMsg = "No " + (msg == null ? "message" : "decorations") + " given. Cannot decorate.";
            LOG.debug(errorMsg);
            result.setException(new IllegalArgumentException(errorMsg));
            return result;
        }
        if (this.config.getDecorationDirective() == DecoratorServiceConfiguration.EShowDecorationsDirective.NEVER || this.config.getDecorationLocation() == DecoratorServiceConfiguration.EDecorationLocation.NOWHERE) {
            LOG.debug("Decoration disabled via configuration.");
            return result;
        }
        LOG.debug("Decorations requested: {}", decorations);
        List<IDecoratorService.EDecoration> decos = this.prepareDecorations(decorations);
        LOG.debug("Decorations prepared: {}", decos);
        if (decos.isEmpty()) {
            LOG.debug("After preparing decorations, none was left, so no decoration will happen.");
            return result;
        }
        if (this.isDecryptionFailed(decos)) {
            LOG.debug("Decryption of message failed, so do not change message, as recommended by RFC standard.");
            return result;
        }
        if (this.config.getDecorationDirective() == DecoratorServiceConfiguration.EShowDecorationsDirective.EXISTING && !this.isProtectionExisting(decos)) {
            LOG.debug("Configured to only display decorations on existing protection, but there was none.");
            return result;
        }
        result.setLocation(this.config.getDecorationLocation());
        result.getDecorations().addAll(this.createDecorations(decos));
        this.decorateMsg(result);
        return result;
    }

    private boolean isProtectionExisting(List<IDecoratorService.EDecoration> decos) {
        return decos.stream().anyMatch(PROTECTION_EXISTING::contains);
    }

    private boolean isDecryptionFailed(List<IDecoratorService.EDecoration> decos) {
        return decos.stream().anyMatch(DECRYPTION_FAILED::contains);
    }

    private List<IDecoratorService.EDecoration> prepareDecorations(Iterable<IDecoratorService.EDecoration> decos) {
        Stream<IDecoratorService.EDecoration> stream = StreamSupport.stream(decos.spliterator(), false);
        stream = stream.sorted((a, b) -> ORDERING.get(a).compareTo(ORDERING.get(b)));
        List<IDecoratorService.EDecoration> preparedDecos = (stream = stream.filter(new FoundFilter(CRYPTO_PRIO.keySet())).filter(new FoundFilter(ENCRYPTED_PRIO.keySet())).filter(new FoundFilter(SIGNED_PRIO.keySet()))).collect(Collectors.toList());
        if (preparedDecos.contains((Object)IDecoratorService.EDecoration.NO_CRYPTOGRAPHY)) {
            return Collections.singletonList(IDecoratorService.EDecoration.NO_CRYPTOGRAPHY);
        }
        return preparedDecos;
    }

    private List<IDecoration> createDecorations(List<IDecoratorService.EDecoration> decos) {
        DecorationFactory factory = DecorationFactory.get();
        return decos.stream().map(factory::create).collect(Collectors.toList());
    }

    private void decorateMsg(IDecoratorService.DecorationResult result) {
        switch (result.getLocation()) {
            case BODY: {
                this.decorateBody(result);
                break;
            }
            case SUBJECT: {
                this.decorateSubject(result);
                break;
            }
        }
    }

    private void decorateSubject(IDecoratorService.DecorationResult result) {
        StringBuilder builder = new StringBuilder(128);
        builder.append('[');
        for (IDecoration deco : result.getDecorations()) {
            builder.append(deco.buildText());
            builder.append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(']');
        builder.append(' ');
        MimeMessage source = result.getMessage();
        try {
            builder.append(source.getSubject());
        }
        catch (MessagingException e) {
            LOG.error("Could not get subject of message with ID \"" + result.getMessageId() + "\". Error message: " + e.getMessage(), (Throwable)e);
            result.setException((Exception)((Object)e));
            return;
        }
        try {
            source.setSubject(builder.toString(), "UTF-8");
        }
        catch (MessagingException e) {
            LOG.error("Could not set subject of message with ID \"" + result.getMessageId() + "\". Error message: " + e.getMessage(), (Throwable)e);
            result.setException((Exception)((Object)e));
            return;
        }
    }

    private void decorateBody(IDecoratorService.DecorationResult result) {
        try {
            MimeMessage source = result.getMessage();
            MimeBodyPart part1 = this.createDecorationPart(result.getDecorations());
            MimeBodyPart part2 = this.createContentPart(source);
            MimeMultipart multi = new MimeMultipart();
            multi.addBodyPart((BodyPart)part1);
            multi.addBodyPart((BodyPart)part2);
            source.setContent((Multipart)multi);
            source.setDisposition(null);
            source.saveChanges();
            source.setHeader("Message-ID", result.getMessageId());
        }
        catch (IOException | MessagingException e) {
            LOG.error("Could not decorate message with ID \"" + result.getMessageId() + "\". Error message: " + e.getMessage(), e);
            result.setException((Exception)e);
        }
    }

    private MimeBodyPart createDecorationPart(Collection<IDecoration> decos) throws MessagingException {
        StringBuilder builder = new StringBuilder(1000);
        builder.append("<!DOCTYPE html><html><head><title>Security Status</title></head><body>\n");
        for (IDecoration deco : decos) {
            builder.append(deco.buildHtml());
        }
        builder.append("\n<hr>");
        builder.append("</body></html>");
        MimeBodyPart part = new MimeBodyPart();
        part.setText(builder.toString(), "UTF-8", "html");
        part.setDescription("Security Status as HTML.");
        return part;
    }

    private MimeBodyPart createContentPart(MimeMessage source) throws IOException, MessagingException {
        MimeBodyPart part2 = new MimeBodyPart();
        MessageUtil.movePart((Part)source, (Part)part2);
        part2.setDescription("Actual Content from Message.");
        return part2;
    }

    private static final class FoundFilter
    implements Predicate<IDecoratorService.EDecoration> {
        private final Set<IDecoratorService.EDecoration> decos;
        private boolean found;

        private FoundFilter(Set<IDecoratorService.EDecoration> decos) {
            this.decos = decos;
        }

        @Override
        public boolean test(IDecoratorService.EDecoration t) {
            if (!this.decos.contains((Object)t)) {
                return true;
            }
            if (this.found) {
                return false;
            }
            this.found = true;
            return true;
        }
    }
}

