/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.decorator;

import net.savignano.uptrust.service.config.converter.EnumConverter;
import net.savignano.uptrust.service.decorator.DecoratorService;
import net.savignano.uptrust.service.decorator.DecoratorServiceConfiguration;
import org.apache.commons.configuration2.ImmutableConfiguration;

public class DecoratorServiceBuilder {
    private static final String SHOW_DECORATIONS_DIRECTIVE_KEY = "insertProtectionIndicators";
    private static final String DECORATION_LOCATION_KEY = "protectionIndicatorLocation";
    private final DecoratorServiceConfiguration config = new DecoratorServiceConfiguration();

    public static final DecoratorServiceBuilder empty() {
        return new DecoratorServiceBuilder();
    }

    public static final DecoratorServiceBuilder from(ImmutableConfiguration config) {
        DecoratorServiceConfiguration.EShowDecorationsDirective decoDirective = ((EnumConverter)new EnumConverter<DecoratorServiceConfiguration.EShowDecorationsDirective>(DecoratorServiceConfiguration.EShowDecorationsDirective.class).from(config, SHOW_DECORATIONS_DIRECTIVE_KEY)).get(DecoratorServiceConfiguration.EShowDecorationsDirective.EXISTING);
        DecoratorServiceConfiguration.EDecorationLocation decoLocation = ((EnumConverter)new EnumConverter<DecoratorServiceConfiguration.EDecorationLocation>(DecoratorServiceConfiguration.EDecorationLocation.class).from(config, DECORATION_LOCATION_KEY)).get(DecoratorServiceConfiguration.EDecorationLocation.BODY);
        return DecoratorServiceBuilder.empty().directive(decoDirective).location(decoLocation);
    }

    private DecoratorServiceBuilder() {
    }

    public DecoratorService build() {
        return new DecoratorService(new DecoratorServiceConfiguration(this.config));
    }

    public DecoratorServiceBuilder location(DecoratorServiceConfiguration.EDecorationLocation location) {
        this.config.setDecorationLocation(location);
        return this;
    }

    public DecoratorServiceBuilder directive(DecoratorServiceConfiguration.EShowDecorationsDirective directive) {
        this.config.setDecorationDirective(directive);
        return this;
    }
}

