/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.decorator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.uptrust.service.MessageResult;
import net.savignano.uptrust.service.decoration.IDecoration;
import net.savignano.uptrust.service.decorator.DecoratorServiceConfiguration;

public interface IDecoratorService {
    public DecorationResult decorate(MimeMessage var1, Iterable<EDecoration> var2);

    default public DecorationResult decorate(MimeMessage msg, EDecoration ... decorations) {
        return this.decorate(msg, decorations == null ? null : Arrays.asList(decorations));
    }

    public static class DecorationResult
    extends MessageResult {
        private final List<IDecoration> decorations = new ArrayList<IDecoration>();
        private DecoratorServiceConfiguration.EDecorationLocation location = DecoratorServiceConfiguration.EDecorationLocation.NOWHERE;

        public List<IDecoration> getDecorations() {
            return this.decorations;
        }

        public DecoratorServiceConfiguration.EDecorationLocation getLocation() {
            return this.location;
        }

        public void setLocation(DecoratorServiceConfiguration.EDecorationLocation location) {
            this.location = location;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(super.toString());
            builder.deleteCharAt(builder.length() - 1);
            builder.append(", location=");
            builder.append((Object)this.getLocation());
            builder.append(", decorations=");
            builder.append(this.getDecorations());
            builder.append("]");
            return builder.toString();
        }
    }

    public static enum EDecoration {
        PGP,
        SMIME,
        NO_CRYPTOGRAPHY,
        SIGNED,
        NOT_SIGNED,
        SIGNED_UNVERIFIED,
        SIGNED_MISMATCH,
        SIGNED_FAILURE,
        ENCRYPTED,
        NOT_ENCRYPTED,
        ENCRYPTED_UNKNOWN,
        ENCRYPTED_FAILURE;


        public static final EDecoration fromCryptography(ECryptographyType cryptography) {
            switch (cryptography) {
                case PGP: {
                    return PGP;
                }
                case SMIME: {
                    return SMIME;
                }
                case NONE: {
                    return NO_CRYPTOGRAPHY;
                }
            }
            throw new IllegalArgumentException("Unknown cryptography encountered: " + String.valueOf(cryptography));
        }
    }
}

