/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.key;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.loader.IKeyLoader;
import net.savignano.uptrust.service.key.IKeyService;
import net.savignano.uptrust.service.key.KeyServiceConfiguration;
import net.savignano.uptrust.service.key.cache.CaffeineCache;
import net.savignano.uptrust.service.key.cache.CaffeineCacheLoader;
import net.savignano.uptrust.service.key.cache.IKeyCache;
import net.savignano.uptrust.service.key.storer.IKeyStorer;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyService
implements IKeyService {
    private static final Logger LOG = LoggerFactory.getLogger(KeyService.class);
    private final KeyServiceConfiguration config;
    private final Map<Pair<? extends Class<? extends ICryptographyKey<?>>, ? extends Class<?>>, IKeyCache<? extends ICryptographyKey<?>, ?>> keys;

    public KeyService(KeyServiceConfiguration config) {
        this.config = config;
        this.keys = new HashMap();
    }

    @Override
    public <T extends ICryptographyKey<?>> T getKey(Object keyFor, Class<T> keyType) {
        if (keyFor == null) {
            return null;
        }
        LOG.info("Retrieving key for: {}", keyFor);
        Pair lookupType = Pair.of(keyType, keyFor.getClass());
        ICryptographyKey key = (ICryptographyKey)keyType.cast(this.getCache(lookupType, true).loadKey(keyFor));
        LOG.info("Retrieved key: {}", (Object)key);
        return (T)key;
    }

    @Override
    public void setKey(Object keyFor, ICryptographyKey<?> key) {
        if (keyFor == null || key == null) {
            return;
        }
        LOG.info("Storing key for \"{}\": {}", keyFor, key);
        Pair lookupType = Pair.of(key.getClass(), keyFor.getClass());
        IKeyStorer<ICryptographyKey<?>, Object> storer = this.getStorer(lookupType);
        storer.storeKey(keyFor, key);
        this.invalidateKey(keyFor, lookupType);
    }

    @Override
    public void removeKey(Object keyFor, Class<? extends ICryptographyKey<?>> keyType) {
        if (keyFor == null || keyType == null) {
            return;
        }
        LOG.info("Removing key for: {}", keyFor);
        Pair lookupType = Pair.of(keyType, keyFor.getClass());
        IKeyStorer storer = this.getStorer(lookupType);
        storer.removeKey(keyFor);
        this.invalidateKey(keyFor, lookupType);
    }

    private <T extends ICryptographyKey<?>, U> void invalidateKey(U keyFor, Pair<Class<T>, Class<U>> lookupType) {
        IKeyCache<T, U> keyCache = this.getCache(lookupType, false);
        if (keyCache != null) {
            LOG.debug("Invalidating key for: {}", keyFor);
            keyCache.invalidate(keyFor);
        }
    }

    private <T extends ICryptographyKey<?>, U> IKeyCache<T, U> getCache(Pair<Class<T>, Class<U>> lookupType, boolean create) {
        LOG.debug("Looking up cache for: {}", lookupType);
        IKeyCache<Object, Object> keyCache = this.keys.get(lookupType);
        if (keyCache == null && create) {
            keyCache = this.createCache(lookupType);
            this.keys.put(lookupType, keyCache);
        }
        return keyCache;
    }

    private <T extends ICryptographyKey<?>, U> IKeyCache<T, U> createCache(Pair<Class<T>, Class<U>> lookupType) {
        LOG.debug("Creating cache for: {}", lookupType);
        IKeyLoader<T, U> loader = this.createLoader(lookupType);
        CaffeineCacheLoader<U, T> cacheLoader = new CaffeineCacheLoader<U, T>(loader);
        if (this.config.getDomainMap() != null) {
            cacheLoader.getDomainMap().putAll(this.config.getDomainMap());
        }
        LoadingCache loadingCache = Caffeine.newBuilder().expireAfterAccess(Duration.ofHours(6L)).maximumSize(100L).refreshAfterWrite(Duration.ofHours(1L)).build(cacheLoader);
        CaffeineCache cache = new CaffeineCache(loadingCache, loader.getCryptography());
        return cache;
    }

    private <T extends ICryptographyKey<?>, U> IKeyLoader<T, U> createLoader(Pair<Class<T>, Class<U>> loaderType) {
        LOG.debug("Creating loader for: {}", loaderType);
        return this.config.getFactory().getLoaderFallback((Class)loaderType.getLeft(), (Class)loaderType.getRight());
    }

    private <T extends ICryptographyKey<?>, U> IKeyStorer<T, U> getStorer(Pair<Class<T>, Class<U>> lookupType) {
        LOG.debug("Lookup up storer for: {}", lookupType);
        return this.config.getFactory().getStorerFallback((Class)lookupType.getLeft(), (Class)lookupType.getRight());
    }
}

