/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.key;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.uptrust.service.config.converter.EnumConverter;
import net.savignano.uptrust.service.key.KeyService;
import net.savignano.uptrust.service.key.KeyServiceConfiguration;
import net.savignano.uptrust.service.key.manager.factory.IKeyManagerFactory;
import net.savignano.uptrust.service.key.manager.factory.UptrustKeyManagerFactory;
import net.savignano.uptrust.service.password.IPasswordDecoderSupplier;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.ImmutableHierarchicalConfiguration;
import org.apache.commons.lang3.tuple.Pair;

public class KeyServiceBuilder {
    private static final String KEY_SOURCES_KEY = "keysources";
    private static final String DOMAIN_KEYS_KEY = "domainkeys";
    private static final String EMAIL_KEY = "email";
    private static final String CRYPTOGRAPHY_KEY = "[@type]";
    private final KeyServiceConfiguration config = new KeyServiceConfiguration();

    public static final KeyServiceBuilder empty() {
        return new KeyServiceBuilder();
    }

    public static final KeyServiceBuilder from(ImmutableHierarchicalConfiguration config, IPasswordDecoderSupplier passwordSupplier) {
        UptrustKeyManagerFactory factory = new UptrustKeyManagerFactory(config.immutableConfigurationAt(KEY_SOURCES_KEY), passwordSupplier);
        Iterable<Pair<String, ECryptographyType>> domains = KeyServiceBuilder.domainsFromConfig(config.immutableConfigurationAt(DOMAIN_KEYS_KEY));
        return KeyServiceBuilder.empty().withFactory(factory).withDomainSpecificEmails(domains);
    }

    private static final Iterable<Pair<String, ECryptographyType>> domainsFromConfig(ImmutableHierarchicalConfiguration configs) {
        ArrayList<Pair<String, ECryptographyType>> pairs = new ArrayList<Pair<String, ECryptographyType>>(configs.size());
        for (ImmutableHierarchicalConfiguration config : configs.immutableConfigurationsAt(EMAIL_KEY)) {
            String email = config.getString(null);
            ECryptographyType cryptoType = ((EnumConverter)new EnumConverter<ECryptographyType>(ECryptographyType.class).from((ImmutableConfiguration)config, CRYPTOGRAPHY_KEY)).get(ECryptographyType.NONE);
            pairs.add((Pair<String, ECryptographyType>)Pair.of((Object)email, (Object)cryptoType));
        }
        return pairs;
    }

    private KeyServiceBuilder() {
    }

    public KeyService build() {
        return new KeyService(this.getConfig());
    }

    public KeyServiceConfiguration getConfig() {
        return new KeyServiceConfiguration(this.config);
    }

    public KeyServiceBuilder withFactory(IKeyManagerFactory factory) {
        this.config.setFactory(factory);
        return this;
    }

    public KeyServiceBuilder withDomainMap(Map<Pair<String, ECryptographyType>, String> domainMap) {
        this.config.setDomainMap(domainMap);
        return this;
    }

    public KeyServiceBuilder withDomainSpecificEmails(Iterable<Pair<String, ECryptographyType>> pairs) {
        HashMap<Pair<String, ECryptographyType>, String> map = new HashMap<Pair<String, ECryptographyType>, String>();
        for (Pair<String, ECryptographyType> pair : pairs) {
            String email = (String)pair.getLeft();
            ECryptographyType crypto = (ECryptographyType)pair.getRight();
            int index = email.indexOf(64);
            if (index == -1) continue;
            String domain = email.substring(index + 1);
            if (crypto == ECryptographyType.NONE) {
                for (ECryptographyType type : ECryptographyType.values()) {
                    map.put((Pair<String, ECryptographyType>)Pair.of((Object)domain, (Object)type), email);
                }
                continue;
            }
            map.put((Pair<String, ECryptographyType>)Pair.of((Object)domain, (Object)crypto), email);
        }
        return this.withDomainMap(map);
    }

    public KeyServiceBuilder withDomainEmails(Iterable<String> emails) {
        HashMap<Pair<String, ECryptographyType>, String> map = new HashMap<Pair<String, ECryptographyType>, String>();
        for (String email : emails) {
            int index = email.indexOf(64);
            if (index == -1) continue;
            String domain = email.substring(index + 1);
            for (ECryptographyType type : ECryptographyType.values()) {
                map.put((Pair<String, ECryptographyType>)Pair.of((Object)domain, (Object)type), email);
            }
        }
        return this.withDomainMap(map);
    }
}

