/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.key.cache;

import com.github.benmanes.caffeine.cache.LoadingCache;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.uptrust.service.key.cache.IKeyCache;

public class CaffeineCache<T extends ICryptographyKey<?>, U>
implements IKeyCache<T, U> {
    private final LoadingCache<U, T> cache;
    private final ECryptographyType cryptography;

    public CaffeineCache(LoadingCache<U, T> cache, ECryptographyType cryptography) {
        this.cache = cache;
        this.cryptography = cryptography;
        if (cache == null) {
            throw new IllegalArgumentException("Cache must not be null.");
        }
    }

    public T loadKey(U forId) {
        return (T)((ICryptographyKey)this.cache.get(forId));
    }

    public EKeySource getKeySource() {
        return EKeySource.UNKNOWN;
    }

    public ECryptographyType getCryptography() {
        return this.cryptography;
    }

    @Override
    public void invalidate(U forId) {
        this.cache.invalidate(forId);
    }

    @Override
    public void invalidateAll() {
        this.cache.invalidateAll();
    }
}

