/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.key.cache;

import com.github.benmanes.caffeine.cache.CacheLoader;
import java.util.HashMap;
import java.util.Map;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyPurpose;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.ValidityKeyFactory;
import net.savignano.cryptography.key.loader.IKeyLoader;
import org.apache.commons.lang3.tuple.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineCacheLoader<K, V extends ICryptographyKey<?>>
implements CacheLoader<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(CaffeineCacheLoader.class);
    private final IKeyLoader<V, K> loader;
    private final Map<Pair<String, ECryptographyType>, String> domainMap;

    public CaffeineCacheLoader(IKeyLoader<V, K> loader) {
        this.loader = loader;
        this.domainMap = new HashMap<Pair<String, ECryptographyType>, String>();
        if (loader == null) {
            throw new IllegalArgumentException("Loader must not be null.");
        }
    }

    public @Nullable V load(K key) throws Exception {
        Class<?> cryptoKeyClass;
        Object domainKey;
        LOG.trace("Loading key for: {}", key);
        ICryptographyKey cryptoKey = this.loader.loadKey(key);
        if (cryptoKey.isValid()) {
            return (V)cryptoKey;
        }
        if (cryptoKey.getKeyPurpose() == EKeyPurpose.ENCRYPTION && (domainKey = this.getDomainKey(key, cryptoKeyClass = cryptoKey.getClass(), cryptoKey.getCryptography())).isValid()) {
            return (V)domainKey;
        }
        return (V)cryptoKey;
    }

    public V reload(K key, V oldValue) throws Exception {
        LOG.trace("Reloading key for: {}", key);
        V newValue = this.load(key);
        if (newValue.getKeyValidity().ordinal() <= oldValue.getKeyValidity().ordinal()) {
            return newValue;
        }
        return oldValue;
    }

    private V getDomainKey(K email, Class<V> cryptoKeyClass, ECryptographyType cryptoType) {
        LOG.trace("Loading domain key for: {}", email);
        if (!(email instanceof String)) {
            LOG.warn("Could not load domain key. Expected email, but got: {}", email);
            return (V)ValidityKeyFactory.getInstance().create(cryptoKeyClass, EKeyValidity.ERROR);
        }
        Pair domainMapKey = Pair.of((Object)this.getDomain((String)email), (Object)cryptoType);
        String domainEmail = this.getDomainMap().get(domainMapKey);
        if (domainEmail == null) {
            return (V)ValidityKeyFactory.getInstance().create(cryptoKeyClass, EKeyValidity.NOT_FOUND);
        }
        return (V)this.loader.loadKey((Object)domainEmail);
    }

    private String getDomain(String email) {
        int index = email.indexOf(64);
        if (index != -1) {
            return email.substring(index + 1);
        }
        return null;
    }

    public Map<Pair<String, ECryptographyType>, String> getDomainMap() {
        return this.domainMap;
    }
}

