/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.key.manager.factory;

import java.util.Optional;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.ValidityKeyFactory;
import net.savignano.cryptography.key.loader.IKeyLoader;
import net.savignano.cryptography.key.loader.StaticKeyLoader;
import net.savignano.uptrust.service.key.storer.IKeyStorer;

public interface IKeyManagerFactory {
    public <T extends ICryptographyKey<?>, U> Optional<IKeyLoader<T, U>> getLoader(Class<T> var1, Class<U> var2);

    public <T extends ICryptographyKey<?>, U> Optional<IKeyStorer<T, U>> getStorer(Class<T> var1, Class<U> var2);

    default public <T extends ICryptographyKey<?>, U> IKeyLoader<T, U> getLoaderFallback(Class<T> keyType, Class<U> forIdType) {
        return this.getLoader(keyType, forIdType).orElseGet(() -> StaticKeyLoader.transform((ICryptographyKey)ValidityKeyFactory.getInstance().create(keyType, EKeyValidity.NOT_FOUND)));
    }

    default public <T extends ICryptographyKey<?>, U> IKeyStorer<T, U> getStorerFallback(Class<T> keyType, Class<U> forIdType) {
        return this.getStorer(keyType, forIdType).orElseGet(() -> new IKeyStorer<T, U>(){

            @Override
            public void storeKey(U forId, T key) {
            }

            @Override
            public void removeKey(U forId) {
            }

            @Override
            public EKeySource getKeySource() {
                return EKeySource.UNKNOWN;
            }

            @Override
            public ECryptographyType getCryptography() {
                return ECryptographyType.NONE;
            }
        });
    }
}

