/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.key.manager.factory;

import java.security.KeyManagementException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.loader.CompoundKeyLoader;
import net.savignano.cryptography.key.loader.IKeyLoader;
import net.savignano.uptrust.service.key.manager.factory.IKeyManagerFactory;
import net.savignano.uptrust.service.key.manager.factory.INeedsPasswordDecoder;
import net.savignano.uptrust.service.key.source.GlobalDirectorySourceFactory;
import net.savignano.uptrust.service.key.source.IKeySourceFactory;
import net.savignano.uptrust.service.key.source.KeyBoxSourceFactory;
import net.savignano.uptrust.service.key.source.KeyServerSourceFactory;
import net.savignano.uptrust.service.key.source.LdapSourceFactory;
import net.savignano.uptrust.service.key.source.PgpKeyStoreSourceFactory;
import net.savignano.uptrust.service.key.source.SmimeKeyStoreSourceFactory;
import net.savignano.uptrust.service.key.storer.IKeyStorer;
import net.savignano.uptrust.service.password.IPasswordDecoderSupplier;
import org.apache.commons.configuration2.ImmutableHierarchicalConfiguration;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UptrustKeyManagerFactory
implements IKeyManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(UptrustKeyManagerFactory.class);
    private static final String KEYSOURCE_KEY = "keysource";
    private static final String ENABLED_KEY = "[@enabled]";
    private static final List<IKeySourceFactory> FACTORIES = new ArrayList<IKeySourceFactory>();
    private final Map<Pair<Class<? extends ICryptographyKey<?>>, Class<?>>, CompoundKeyLoader<ICryptographyKey<?>, ?>> loaders = new HashMap();
    private final Map<Pair<Class<? extends ICryptographyKey<?>>, Class<?>>, IKeyStorer<ICryptographyKey<?>, ?>> storers = new HashMap();

    public UptrustKeyManagerFactory(ImmutableHierarchicalConfiguration config, IPasswordDecoderSupplier passwordSupplier) {
        this(config == null ? null : config.immutableConfigurationsAt(KEYSOURCE_KEY), passwordSupplier);
    }

    public UptrustKeyManagerFactory(Collection<ImmutableHierarchicalConfiguration> configs, IPasswordDecoderSupplier passwordSupplier) {
        this.create((Collection<ImmutableHierarchicalConfiguration>)(configs == null ? Collections.EMPTY_LIST : configs), passwordSupplier);
    }

    private void create(Collection<ImmutableHierarchicalConfiguration> configs, IPasswordDecoderSupplier passwordSupplier) {
        if (configs.isEmpty()) {
            LOG.warn("No key sources configured.");
            return;
        }
        if (passwordSupplier == null) {
            LOG.warn("No password decoder supplied. Only plain text passwords can be used.");
            this.create(configs, alg -> password -> password == null ? null : password.toCharArray());
            return;
        }
        boolean fatal = false;
        try {
            int index = 0;
            for (ImmutableHierarchicalConfiguration config : configs) {
                IKeySourceFactory.KeySource source;
                IKeySourceFactory.SourceData data;
                try {
                    data = IKeySourceFactory.SourceData.createFromConfig(config);
                }
                catch (Exception e) {
                    LOG.error("Could not read key source configuration with index " + index++ + ".", (Throwable)e);
                    fatal = true;
                    continue;
                }
                if (data.id() == null) {
                    String id = "<Index " + index + ">";
                    data = new IKeySourceFactory.SourceData(id, data.sourceType(), data.cryptography(), data.confidentiality(), data.readOnly(), data.config());
                }
                ++index;
                if (!config.getBoolean(ENABLED_KEY, true)) {
                    LOG.info("Key source \"{}\" is disabled.", (Object)data.id());
                    continue;
                }
                IKeySourceFactory factory = this.lookupFactory(data);
                if (factory == null) {
                    LOG.error("No factory found to load source: {}", (Object)data);
                    fatal = true;
                    continue;
                }
                if (factory instanceof INeedsPasswordDecoder) {
                    INeedsPasswordDecoder needs = (INeedsPasswordDecoder)((Object)factory);
                    needs.supplyPasswordDecoder(passwordSupplier);
                }
                LOG.info("Creating source for key source: {}", (Object)data);
                try {
                    source = factory.create(data);
                }
                catch (KeyManagementException e) {
                    LOG.error("Could not create key source for source " + String.valueOf(data) + ".", (Throwable)e);
                    fatal = true;
                    continue;
                }
                this.fillLoadersMap(source.keyLoaders());
                this.fillStorersMap(source.keyStorers());
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            fatal = true;
        }
        if (fatal) {
            throw new RuntimeException("Could not load all key sources. To protect email integrity, Uptrust will not be started. Please fix key sources and try again.");
        }
    }

    private IKeySourceFactory lookupFactory(IKeySourceFactory.SourceData data) {
        for (IKeySourceFactory factory : FACTORIES) {
            if (!factory.isResponsible(data)) continue;
            LOG.debug("Factory responsible for {}: {}", (Object)data, (Object)factory.getClass().getSimpleName());
            return factory;
        }
        return null;
    }

    private void fillLoadersMap(Map<Pair<Class<? extends ICryptographyKey<?>>, Class<?>>, IKeyLoader<?, ?>> createdLoaders) {
        for (Pair<Class<ICryptographyKey<?>>, Class<?>> pair : createdLoaders.keySet()) {
            CompoundKeyLoader compoundLoader = this.loaders.get(pair);
            if (compoundLoader == null) {
                compoundLoader = new CompoundKeyLoader((Class)pair.getLeft());
                this.loaders.put(pair, compoundLoader);
            }
            IKeyLoader<?, ?> createdLoader = createdLoaders.get(pair);
            compoundLoader.getKeyLoaders().add(createdLoader);
        }
    }

    private void fillStorersMap(Map<Pair<Class<? extends ICryptographyKey<?>>, Class<?>>, IKeyStorer<?, ?>> createdStorers) {
        for (Pair<Class<ICryptographyKey<?>>, Class<?>> pair : createdStorers.keySet()) {
            if (this.storers.containsKey(pair)) {
                LOG.warn("Factory already contains a key storer for {}. Storer will not be used: {}", pair, this.storers.get(pair));
                continue;
            }
            IKeyStorer<?, ?> createdLoader = createdStorers.get(pair);
            this.storers.put(pair, createdLoader);
        }
    }

    @Override
    public <T extends ICryptographyKey<?>, U> Optional<IKeyLoader<T, U>> getLoader(Class<T> keyType, Class<U> forIdType) {
        CompoundKeyLoader<ICryptographyKey<?>, ?> loader = this.loaders.get(Pair.of(keyType, forIdType));
        return Optional.ofNullable(loader);
    }

    @Override
    public <T extends ICryptographyKey<?>, U> Optional<IKeyStorer<T, U>> getStorer(Class<T> keyType, Class<U> forIdType) {
        IKeyStorer<ICryptographyKey<?>, ?> storer = this.storers.get(Pair.of(keyType, forIdType));
        return Optional.ofNullable(storer);
    }

    static {
        FACTORIES.add(GlobalDirectorySourceFactory.INSTANCE);
        FACTORIES.add(KeyBoxSourceFactory.INSTANCE);
        FACTORIES.add(KeyServerSourceFactory.INSTANCE);
        FACTORIES.add(LdapSourceFactory.INSTANCE);
        FACTORIES.add(PgpKeyStoreSourceFactory.INSTANCE);
        FACTORIES.add(SmimeKeyStoreSourceFactory.INSTANCE);
    }
}

