/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.key.source;

import java.net.URL;
import java.security.KeyManagementException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.savignano.cryptography.connector.LdapConnector;
import net.savignano.uptrust.service.config.converter.PasswordConverter;
import net.savignano.uptrust.service.config.converter.UrlConverter;
import net.savignano.uptrust.service.key.manager.factory.INeedsPasswordDecoder;
import net.savignano.uptrust.service.key.source.IKeySourceFactory;
import net.savignano.uptrust.service.password.IPasswordDecoderSupplier;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.ImmutableHierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;

public abstract class ALdapSourceFactory
implements IKeySourceFactory,
INeedsPasswordDecoder {
    protected static final String HOST_URL_KEY = "hostURL";
    protected static final String BASE_DN_KEY = "baseDN";
    protected static final String FILTER_KEY = "filter";
    protected static final String MAIL_ATTRIBUTE_KEY = "emailAttribute";
    protected static final String DISABLE_TRUST_CHECK_KEY = "disableTrustCheck";
    protected static final String AUTH_TYPE_KEY = "auth.type";
    protected static final String AUTH_USER_KEY = "auth.user";
    protected static final String AUTH_PASSWORD_KEY = "auth.password";
    protected static final String NO_AUTH_VALUE = "none";
    protected static final String SIMPLE_AUTH_VALUE = "simple";
    protected static final String ENVIRONMENT_KEY = "env";
    protected static final String DISABLE_CONNECTION_CHECK_KEY = "disableConnectionCheck";
    private IPasswordDecoderSupplier passwordSupplier;

    protected LdapConnector createConnector(ImmutableHierarchicalConfiguration config) throws KeyManagementException {
        LdapConnector connector = new LdapConnector();
        this.configureConnectorBase(config, connector);
        this.configureConnectorAuth(config, connector);
        this.configureConnectorHost(config, connector);
        return connector;
    }

    private void configureConnectorBase(ImmutableHierarchicalConfiguration config, LdapConnector connector) {
        connector.setDn(config.getString(BASE_DN_KEY, null));
        connector.setFilter(config.getString(FILTER_KEY, null));
        connector.setDisableTrustCheck(config.getBoolean(DISABLE_TRUST_CHECK_KEY, false));
    }

    private void configureConnectorHost(ImmutableHierarchicalConfiguration config, LdapConnector connector) throws KeyManagementException {
        URL url = this.toUrl(config.getString(HOST_URL_KEY));
        connector.setHost(url.getHost());
        connector.setSsl(url.getProtocol().endsWith("s"));
        connector.setPort(url.getPort() != -1 ? url.getPort() : (connector.isSsl() ? 636 : 389));
    }

    private void configureConnectorAuth(ImmutableHierarchicalConfiguration config, LdapConnector connector) throws KeyManagementException {
        switch (config.getString(AUTH_TYPE_KEY, NO_AUTH_VALUE)) {
            case "none": {
                break;
            }
            case "simple": {
                char[] loginPassword;
                try {
                    loginPassword = (char[])((PasswordConverter)new PasswordConverter().from((ImmutableConfiguration)config, AUTH_PASSWORD_KEY)).useDecoderSupplier(this.getSuppliedPasswordDecoder()).get();
                }
                catch (ConfigurationException e) {
                    throw new KeyManagementException("Could not decrypt login password.", e);
                }
                connector.setLoginUser(config.getString(AUTH_USER_KEY));
                connector.setLoginPassword(loginPassword);
                break;
            }
            default: {
                throw new KeyManagementException("Unknown authorization value in \"auth.type\". Found \"" + config.getString(AUTH_TYPE_KEY) + "\", but only allowed one of: none, simple");
            }
        }
    }

    protected Map<String, String> getEnvironment(ImmutableHierarchicalConfiguration config) {
        Iterator envKeys = config.getKeys(ENVIRONMENT_KEY);
        if (!envKeys.hasNext()) {
            return null;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        while (envKeys.hasNext()) {
            String configKey = (String)envKeys.next();
            if (configKey.length() <= 3) continue;
            String envKey = configKey.substring(ENVIRONMENT_KEY.length() + 1).replace("..", ".");
            String value = config.getString(configKey);
            env.put(envKey, value);
        }
        return env;
    }

    protected URL toUrl(String urlStr) throws KeyManagementException {
        try {
            return (URL)((UrlConverter)new UrlConverter().from(urlStr)).get();
        }
        catch (ConfigurationException e) {
            throw new KeyManagementException("Could not convert URL: " + urlStr, e);
        }
    }

    protected void validateConfig(IKeySourceFactory.SourceData data) throws KeyManagementException {
        if (data.config() == null) {
            throw new KeyManagementException("Configuration element is not present.");
        }
        if (!data.config().containsKey(HOST_URL_KEY)) {
            throw new KeyManagementException("Configuration is missing mandatory 'hostURL' parameter.");
        }
        this.toUrl(data.config().getString(HOST_URL_KEY));
        if (!data.config().getBoolean(DISABLE_CONNECTION_CHECK_KEY, false)) {
            LdapConnector connector = this.createConnector(data.config());
            try {
                connector.connect();
            }
            catch (Exception e) {
                throw new KeyManagementException("Could not connect to \"" + connector.getHost() + "\".", e);
            }
            finally {
                connector.disconnect();
            }
        }
    }

    @Override
    public void supplyPasswordDecoder(IPasswordDecoderSupplier supplier) {
        this.passwordSupplier = supplier;
    }

    protected IPasswordDecoderSupplier getSuppliedPasswordDecoder() {
        return this.passwordSupplier;
    }
}

