/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.key.source;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.util.Optional;
import net.savignano.uptrust.service.key.source.IKeySourceFactory;
import org.apache.commons.configuration2.ImmutableHierarchicalConfiguration;

public abstract class AResourceSourceFactory
implements IKeySourceFactory {
    private static final String FILE_KEY = "file";
    private static final String URL_KEY = "url";

    protected BufferedInputStream getResource(ImmutableHierarchicalConfiguration config) throws KeyManagementException {
        Optional<URL> url;
        Optional<File> file = this.getFile(config);
        if (file.isPresent()) {
            try {
                return new BufferedInputStream(new FileInputStream(file.get()));
            }
            catch (Exception e) {
                throw new KeyManagementException("Could not load resource from file \"" + String.valueOf(file.get()) + "\".", e);
            }
        }
        try {
            url = this.getUrl(config);
        }
        catch (MalformedURLException e) {
            throw new KeyManagementException("Malformed URL \"" + config.getString(URL_KEY) + "\" encountered.", e);
        }
        if (url.isPresent()) {
            try {
                return new BufferedInputStream(url.get().openStream());
            }
            catch (Exception e) {
                throw new KeyManagementException("Could not load resource from URL \"" + String.valueOf(url) + "\".", e);
            }
        }
        throw new KeyManagementException("No resource to load given.");
    }

    protected Optional<File> getFile(ImmutableHierarchicalConfiguration config) {
        if (config.containsKey(FILE_KEY)) {
            return Optional.of(new File(config.getString(FILE_KEY)));
        }
        return Optional.empty();
    }

    protected Optional<URL> getUrl(ImmutableHierarchicalConfiguration config) throws MalformedURLException {
        if (config.containsKey(URL_KEY)) {
            return Optional.of(new URL(config.getString(URL_KEY)));
        }
        return Optional.empty();
    }

    protected void validateConfig(IKeySourceFactory.SourceData data) throws KeyManagementException {
        if (data.config() == null) {
            throw new KeyManagementException("Configuration element is not present.");
        }
        if (!data.config().containsKey(FILE_KEY) && !data.config().containsKey(URL_KEY)) {
            throw new KeyManagementException("Configuration must either have 'file' or 'url' parameter.");
        }
        Optional<File> file = this.getFile(data.config());
        if (file.isPresent() && !file.get().canRead()) {
            throw new KeyManagementException("File \"" + String.valueOf(file.get()) + "\" is not readable.");
        }
    }
}

