/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.key.source;

import java.net.URL;
import java.security.KeyManagementException;
import java.util.Map;
import java.util.Objects;
import net.savignano.cryptography.connector.LdapConnector;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.key.loader.IKeyLoader;
import net.savignano.cryptography.key.loader.KeyLoaderTransformer;
import net.savignano.cryptography.key.loader.pgp.PgpGlobalDirectoryLoader;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.uptrust.service.key.source.ALdapSourceFactory;
import net.savignano.uptrust.service.key.source.IKeySourceFactory;
import org.apache.commons.lang3.tuple.Pair;

public class GlobalDirectorySourceFactory
extends ALdapSourceFactory {
    public static final GlobalDirectorySourceFactory INSTANCE = new GlobalDirectorySourceFactory();

    private GlobalDirectorySourceFactory() {
    }

    @Override
    public boolean isResponsible(IKeySourceFactory.SourceData data) {
        return data != null && Objects.equals(data.sourceType(), "globaldirectory") && data.supportsConfidentiality(IKeySourceFactory.EConfidentiality.PUBLIC) && data.supportsCryptography(ECryptographyType.PGP);
    }

    @Override
    public IKeySourceFactory.KeySource create(IKeySourceFactory.SourceData data) throws KeyManagementException {
        if (!this.isResponsible(data)) {
            throw new KeyManagementException("The factory " + this.getClass().getSimpleName() + " cannot be used to create a key source for the given source data: " + String.valueOf(data));
        }
        this.validateConfig(data);
        LdapConnector connector = this.createConnector(data.config());
        Map<String, String> environment = this.getEnvironment(data.config());
        return this.createGlobalDirectory(connector, environment);
    }

    private IKeySourceFactory.KeySource createGlobalDirectory(LdapConnector connector, Map<String, String> environment) {
        IKeySourceFactory.KeySource source = new IKeySourceFactory.KeySource(EKeySource.KEYSERVER);
        Pair key = Pair.of(PgpEncryptionKey.class, String.class);
        PgpGlobalDirectoryLoader directoryLoader = new PgpGlobalDirectoryLoader(connector);
        directoryLoader.setEnvironment(environment);
        IKeyLoader loader = KeyLoaderTransformer.create((IKeyLoader)directoryLoader, email -> Pair.of(null, (Object)((String)email)));
        source.keyLoaders().put(key, loader);
        return source;
    }

    @Override
    protected URL toUrl(String urlStr) throws KeyManagementException {
        if (urlStr.startsWith("hkp")) {
            return super.toUrl("http" + urlStr.substring(3));
        }
        return super.toUrl(urlStr);
    }
}

