/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.key.source;

import java.security.KeyManagementException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.loader.IKeyLoader;
import net.savignano.uptrust.service.config.converter.EnumConverter;
import net.savignano.uptrust.service.key.storer.IKeyStorer;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.ImmutableHierarchicalConfiguration;
import org.apache.commons.lang3.tuple.Pair;

public interface IKeySourceFactory {
    public boolean isResponsible(SourceData var1);

    public KeySource create(SourceData var1) throws KeyManagementException;

    public record KeySource(EKeySource keySource, Map<Pair<Class<? extends ICryptographyKey<?>>, Class<?>>, IKeyLoader<?, ?>> keyLoaders, Map<Pair<Class<? extends ICryptographyKey<?>>, Class<?>>, IKeyStorer<?, ?>> keyStorers) {
        public KeySource(EKeySource keySource) {
            this(keySource, null, null);
        }

        public KeySource(EKeySource keySource, Map<Pair<Class<? extends ICryptographyKey<?>>, Class<?>>, IKeyLoader<?, ?>> keyLoaders, Map<Pair<Class<? extends ICryptographyKey<?>>, Class<?>>, IKeyStorer<?, ?>> keyStorers) {
            this.keySource = keySource;
            this.keyLoaders = keyLoaders != null ? keyLoaders : new LinkedHashMap();
            this.keyStorers = keyStorers != null ? keyStorers : new LinkedHashMap();
        }
    }

    public record SourceData(String id, String sourceType, ECryptographyType cryptography, EConfidentiality confidentiality, boolean readOnly, ImmutableHierarchicalConfiguration config) {
        private static final String ID_KEY = "id";
        private static final String CRYPTOGRAPHY_KEY = "cryptography";
        private static final String CONFIDENTIALITY_KEY = "confidentiality";
        private static final String TYPE_KEY = "type";
        private static final String READ_ONLY_KEY = "readOnly";
        private static final String CHILD_CONFIG_KEY = "config";

        public static SourceData createFromConfig(ImmutableHierarchicalConfiguration config) {
            String id = config.getString(ID_KEY, null);
            String sourceType = config.getString(TYPE_KEY, null);
            ECryptographyType cryptography = ((EnumConverter)new EnumConverter<ECryptographyType>(ECryptographyType.class).from((ImmutableConfiguration)config, CRYPTOGRAPHY_KEY)).get(null);
            EConfidentiality confidentiality = ((EnumConverter)new EnumConverter<EConfidentiality>(EConfidentiality.class).from((ImmutableConfiguration)config, CONFIDENTIALITY_KEY)).get(null);
            boolean readOnly = config.getBoolean(READ_ONLY_KEY, true);
            ImmutableHierarchicalConfiguration childConfig = config.immutableConfigurationAt(CHILD_CONFIG_KEY);
            return new SourceData(id, sourceType, cryptography, confidentiality, readOnly, childConfig);
        }

        public boolean supportsCryptography(ECryptographyType expected) {
            return this.cryptography == null || expected == this.cryptography;
        }

        public boolean supportsConfidentiality(EConfidentiality expected) {
            if (this.confidentiality == null) {
                return true;
            }
            if (expected == this.confidentiality) {
                return true;
            }
            return this.confidentiality == EConfidentiality.BOTH;
        }
    }

    public static enum EConfidentiality {
        PUBLIC,
        PRIVATE,
        BOTH;

    }
}

