/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.key.source;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.util.Map;
import java.util.Objects;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.loader.IKeyLoader;
import net.savignano.cryptography.key.loader.pgp.PgpKeyBoxLoader;
import net.savignano.cryptography.key.loader.pgp.PgpValidationKeyBoxLoader;
import net.savignano.cryptography.key.loader.smime.SmimeKeyBoxLoader;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.key.pgp.PgpValidationKey;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.KeyBox;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.bc.BcKeyBox;
import net.savignano.uptrust.service.key.source.AResourceSourceFactory;
import net.savignano.uptrust.service.key.source.IKeySourceFactory;
import org.apache.commons.configuration2.ImmutableHierarchicalConfiguration;
import org.apache.commons.lang3.tuple.Pair;

public class KeyBoxSourceFactory
extends AResourceSourceFactory {
    public static final KeyBoxSourceFactory INSTANCE = new KeyBoxSourceFactory();

    private KeyBoxSourceFactory() {
    }

    @Override
    public boolean isResponsible(IKeySourceFactory.SourceData data) {
        return data != null && Objects.equals(data.sourceType(), "keybox") && data.supportsConfidentiality(IKeySourceFactory.EConfidentiality.PUBLIC);
    }

    @Override
    public IKeySourceFactory.KeySource create(IKeySourceFactory.SourceData data) throws KeyManagementException {
        if (!this.isResponsible(data)) {
            throw new KeyManagementException("The factory " + this.getClass().getSimpleName() + " cannot be used to create a key source for the given source data: " + String.valueOf(data));
        }
        this.validateConfig(data);
        KeyBox keyBox = this.loadKeyBox(data.config());
        return this.createLoaders(keyBox, data);
    }

    private KeyBox loadKeyBox(ImmutableHierarchicalConfiguration config) throws KeyManagementException {
        BcKeyBox bcKeyBox;
        block8: {
            BufferedInputStream is = this.getResource(config);
            try {
                bcKeyBox = new BcKeyBox((InputStream)new BufferedInputStream(is));
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new KeyManagementException("Could not load S/MIME key box. Error message: " + e.getMessage(), e);
                }
            }
            ((InputStream)is).close();
        }
        return bcKeyBox;
    }

    private IKeySourceFactory.KeySource createLoaders(KeyBox keyBox, IKeySourceFactory.SourceData data) {
        IKeySourceFactory.KeySource source = new IKeySourceFactory.KeySource(EKeySource.KEYSTORE);
        if (data.supportsCryptography(ECryptographyType.SMIME)) {
            source.keyLoaders().putAll(this.createSmimeLoader(keyBox));
        }
        if (data.supportsCryptography(ECryptographyType.PGP)) {
            source.keyLoaders().putAll(this.createPgpLoader(keyBox));
        }
        return source;
    }

    private Map<Pair<Class<? extends ICryptographyKey<?>>, Class<?>>, IKeyLoader<?, ?>> createSmimeLoader(KeyBox keyBox) {
        Pair key = Pair.of(SmimeEncryptionKey.class, String.class);
        SmimeKeyBoxLoader loader = new SmimeKeyBoxLoader(keyBox);
        return Map.of(key, loader);
    }

    private Map<Pair<Class<? extends ICryptographyKey<?>>, Class<?>>, IKeyLoader<?, ?>> createPgpLoader(KeyBox keyBox) {
        Pair key1 = Pair.of(PgpEncryptionKey.class, String.class);
        PgpKeyBoxLoader loader1 = new PgpKeyBoxLoader(keyBox);
        Pair key2 = Pair.of(PgpValidationKey.class, Long.class);
        PgpValidationKeyBoxLoader loader2 = new PgpValidationKeyBoxLoader(keyBox);
        return Map.of(key1, loader1, key2, loader2);
    }
}

