/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.key.source;

import java.security.KeyManagementException;
import java.util.Objects;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.loader.IKeyLoader;
import net.savignano.cryptography.key.loader.pgp.PgpKeyServerLoader;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.uptrust.service.key.source.IKeySourceFactory;
import org.apache.commons.configuration2.ImmutableHierarchicalConfiguration;
import org.apache.commons.lang3.tuple.Pair;

public class KeyServerSourceFactory
implements IKeySourceFactory {
    public static final KeyServerSourceFactory INSTANCE = new KeyServerSourceFactory();
    private static final String URL_KEY = "url";
    private static final String TIMEOUT_KEY = "timeout";
    private static final String ENCODE_KEY = "encodeSearchParam";

    private KeyServerSourceFactory() {
    }

    @Override
    public boolean isResponsible(IKeySourceFactory.SourceData data) {
        return data != null && Objects.equals(data.sourceType(), "keyserver") && data.supportsConfidentiality(IKeySourceFactory.EConfidentiality.PUBLIC) && data.supportsCryptography(ECryptographyType.PGP);
    }

    @Override
    public IKeySourceFactory.KeySource create(IKeySourceFactory.SourceData data) throws KeyManagementException {
        if (!this.isResponsible(data)) {
            throw new KeyManagementException("The factory " + this.getClass().getSimpleName() + " cannot be used to create a key source for the given source data: " + String.valueOf(data));
        }
        this.validateConfig(data);
        return this.createKeySource(data.config());
    }

    private IKeySourceFactory.KeySource createKeySource(ImmutableHierarchicalConfiguration config) {
        IKeySourceFactory.KeySource source = new IKeySourceFactory.KeySource(EKeySource.KEYSERVER);
        Pair key = Pair.of(PgpEncryptionKey.class, String.class);
        String url = config.getString(URL_KEY);
        PgpKeyServerLoader loader = new PgpKeyServerLoader(url);
        if (config.containsKey(TIMEOUT_KEY)) {
            loader.setTimeout(config.getInt(TIMEOUT_KEY));
        }
        if (config.containsKey(ENCODE_KEY)) {
            loader.setEncodeSearchParam(config.getBoolean(ENCODE_KEY));
        }
        source.keyLoaders().put((Pair<Class<ICryptographyKey<?>>, Class<?>>)key, (IKeyLoader<?, ?>)loader);
        return source;
    }

    private void validateConfig(IKeySourceFactory.SourceData data) throws KeyManagementException {
        if (data.config() == null) {
            throw new KeyManagementException("Configuration element is not present.");
        }
        if (!data.config().containsKey(URL_KEY)) {
            throw new KeyManagementException("Configuration is missing mandatory 'url' parameter.");
        }
    }
}

