/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.key.source;

import java.security.KeyManagementException;
import java.util.Map;
import java.util.Objects;
import net.savignano.cryptography.connector.LdapConnector;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.loader.IKeyLoader;
import net.savignano.cryptography.key.loader.KeyLoaderTransformer;
import net.savignano.cryptography.key.loader.pgp.PgpLdapLoader;
import net.savignano.cryptography.key.loader.smime.SmimeLdapLoader;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;
import net.savignano.uptrust.service.key.source.ALdapSourceFactory;
import net.savignano.uptrust.service.key.source.IKeySourceFactory;
import org.apache.commons.lang3.tuple.Pair;

public class LdapSourceFactory
extends ALdapSourceFactory {
    public static final LdapSourceFactory INSTANCE = new LdapSourceFactory();

    private LdapSourceFactory() {
    }

    @Override
    public boolean isResponsible(IKeySourceFactory.SourceData data) {
        return data != null && Objects.equals(data.sourceType(), "ldap") && data.supportsConfidentiality(IKeySourceFactory.EConfidentiality.PUBLIC);
    }

    @Override
    public IKeySourceFactory.KeySource create(IKeySourceFactory.SourceData data) throws KeyManagementException {
        if (!this.isResponsible(data)) {
            throw new KeyManagementException("The factory " + this.getClass().getSimpleName() + " cannot be used to create a key source for the given source data: " + String.valueOf(data));
        }
        this.validateConfig(data);
        return this.createLoaders(data);
    }

    private IKeySourceFactory.KeySource createLoaders(IKeySourceFactory.SourceData data) throws KeyManagementException {
        LdapConnector connector;
        IKeySourceFactory.KeySource source = new IKeySourceFactory.KeySource(EKeySource.STANDARD_LDAP);
        Map<String, String> environment = this.getEnvironment(data.config());
        String emailAttribute = data.config().getString("emailAttribute", "mail");
        if (data.supportsCryptography(ECryptographyType.SMIME)) {
            connector = this.createConnector(data.config());
            source.keyLoaders().putAll(this.createSmimeLoader(connector, environment, emailAttribute));
        }
        if (data.supportsCryptography(ECryptographyType.PGP)) {
            connector = this.createConnector(data.config());
            source.keyLoaders().putAll(this.createPgpLoader(connector, environment, emailAttribute));
        }
        return source;
    }

    private Map<Pair<Class<? extends ICryptographyKey<?>>, Class<?>>, IKeyLoader<?, ?>> createSmimeLoader(LdapConnector connector, Map<String, String> environment, String emailAttribute) {
        Pair key = Pair.of(SmimeEncryptionKey.class, String.class);
        SmimeLdapLoader ldapLoader = new SmimeLdapLoader(connector);
        ldapLoader.setEnvironment(environment);
        IKeyLoader loader = KeyLoaderTransformer.create((IKeyLoader)ldapLoader, email -> Pair.of((Object)("(" + emailAttribute + "=" + String.valueOf(email) + ")"), (Object)((String)email)));
        return Map.of(key, loader);
    }

    private Map<Pair<Class<? extends ICryptographyKey<?>>, Class<?>>, IKeyLoader<?, ?>> createPgpLoader(LdapConnector connector, Map<String, String> environment, String emailAttribute) {
        Pair key = Pair.of(PgpEncryptionKey.class, String.class);
        PgpLdapLoader ldapLoader = new PgpLdapLoader(connector);
        ldapLoader.setEnvironment(environment);
        IKeyLoader loader = KeyLoaderTransformer.create((IKeyLoader)ldapLoader, email -> Pair.of((Object)("(" + emailAttribute + "=" + String.valueOf(email) + ")"), (Object)((String)email)));
        return Map.of(key, loader);
    }

    @Override
    protected void validateConfig(IKeySourceFactory.SourceData data) throws KeyManagementException {
        super.validateConfig(data);
        if (!data.config().containsKey("baseDN")) {
            throw new KeyManagementException("Configuration is missing mandatory 'baseDN' parameter.");
        }
    }
}

