/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.key.source;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.info.InfoData;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.IPublicCryptographyKey;
import net.savignano.cryptography.key.loader.IKeyLoader;
import net.savignano.cryptography.key.loader.pgp.PgpDecryptionKeyStoreLoader;
import net.savignano.cryptography.key.loader.pgp.PgpPublicKeyStoreLoader;
import net.savignano.cryptography.key.loader.pgp.PgpValidationKeyStoreLoader;
import net.savignano.cryptography.key.pgp.PgpDecryptionKey;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.key.pgp.PgpValidationKey;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import net.savignano.uptrust.service.config.converter.PasswordConverter;
import net.savignano.uptrust.service.key.manager.factory.INeedsPasswordDecoder;
import net.savignano.uptrust.service.key.source.AResourceSourceFactory;
import net.savignano.uptrust.service.key.source.IKeySourceFactory;
import net.savignano.uptrust.service.key.storer.IKeyStorer;
import net.savignano.uptrust.service.key.storer.PgpKeyStoreStorer;
import net.savignano.uptrust.service.password.IPasswordDecoderSupplier;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.ImmutableHierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.tuple.Pair;

public class PgpKeyStoreSourceFactory
extends AResourceSourceFactory
implements INeedsPasswordDecoder {
    public static final PgpKeyStoreSourceFactory INSTANCE = new PgpKeyStoreSourceFactory();
    private static final String PASSWORD_KEY = "password";
    private IPasswordDecoderSupplier passwordSupplier;

    private PgpKeyStoreSourceFactory() {
    }

    @Override
    public boolean isResponsible(IKeySourceFactory.SourceData data) {
        return data != null && Objects.equals(data.sourceType(), "keystore") && data.supportsCryptography(ECryptographyType.PGP);
    }

    @Override
    public IKeySourceFactory.KeySource create(IKeySourceFactory.SourceData data) throws KeyManagementException {
        if (!this.isResponsible(data)) {
            throw new KeyManagementException("The factory " + this.getClass().getSimpleName() + " cannot be used to create a key source for the given source data: " + String.valueOf(data));
        }
        this.validateConfig(data);
        return this.createLoaders(data);
    }

    private IKeySourceFactory.KeySource createLoaders(IKeySourceFactory.SourceData data) throws KeyManagementException {
        IKeySourceFactory.KeySource keySource = new IKeySourceFactory.KeySource(EKeySource.KEYSTORE);
        if (data.supportsConfidentiality(IKeySourceFactory.EConfidentiality.PUBLIC)) {
            PGPPublicKeyRingCollection publicKeyStore = this.loadPublicKeyStore(data.config());
            Optional<File> file = this.getFile(data.config());
            if (!data.readOnly() && file.isPresent()) {
                keySource.keyStorers().putAll(this.createPublicStorer(publicKeyStore, file.get()));
                PgpKeyStoreStorer storer = (PgpKeyStoreStorer)keySource.keyStorers().values().iterator().next();
                keySource.keyLoaders().putAll(this.createLinkedLoader(storer));
            } else {
                keySource.keyLoaders().putAll(this.createPublicLoader(publicKeyStore));
            }
        }
        if (data.supportsConfidentiality(IKeySourceFactory.EConfidentiality.PRIVATE)) {
            char[] password;
            try {
                password = (char[])((PasswordConverter)new PasswordConverter().from((ImmutableConfiguration)data.config(), PASSWORD_KEY)).useDecoderSupplier(this.passwordSupplier).get();
            }
            catch (ConfigurationException e) {
                throw new KeyManagementException("Could not decrypt login password.", e);
            }
            PGPSecretKeyRingCollection privateKeyStore = this.loadPrivateKeyStore(data.config());
            keySource.keyLoaders().putAll(this.createPrivateLoader(privateKeyStore, password));
        }
        return keySource;
    }

    private Map<Pair<Class<? extends ICryptographyKey<?>>, Class<?>>, IKeyLoader<?, ?>> createPublicLoader(PGPPublicKeyRingCollection keyStore) {
        Pair key1 = Pair.of(PgpEncryptionKey.class, String.class);
        Pair key2 = Pair.of(PgpValidationKey.class, Long.class);
        PgpPublicKeyStoreLoader loader1 = new PgpPublicKeyStoreLoader(keyStore);
        PgpValidationKeyStoreLoader loader2 = new PgpValidationKeyStoreLoader(keyStore);
        return Map.of(key1, loader1, key2, loader2);
    }

    private Map<Pair<Class<? extends ICryptographyKey<?>>, Class<?>>, IKeyLoader<?, ?>> createPrivateLoader(PGPSecretKeyRingCollection keyStore, char[] password) {
        Pair key = Pair.of(PgpDecryptionKey.class, Long.class);
        PgpDecryptionKeyStoreLoader loader = new PgpDecryptionKeyStoreLoader(keyStore, password);
        return Map.of(key, loader);
    }

    private Map<? extends Pair<Class<? extends ICryptographyKey<?>>, Class<?>>, ? extends IKeyStorer<?, ?>> createPublicStorer(PGPPublicKeyRingCollection publicKeyStore, File file) {
        Pair key = Pair.of(PgpEncryptionKey.class, String.class);
        PgpKeyStoreStorer storer = new PgpKeyStoreStorer(publicKeyStore, file);
        return Map.of(key, storer);
    }

    private Map<? extends Pair<Class<? extends ICryptographyKey<?>>, Class<?>>, ? extends IKeyLoader<?, ?>> createLinkedLoader(PgpKeyStoreStorer storer) {
        Pair key1 = Pair.of(PgpEncryptionKey.class, String.class);
        Pair key2 = Pair.of(PgpValidationKey.class, Long.class);
        LoaderStorerLinker loader1 = new LoaderStorerLinker(PgpPublicKeyStoreLoader::new, storer);
        LoaderStorerLinker loader2 = new LoaderStorerLinker(PgpValidationKeyStoreLoader::new, storer);
        return Map.of(key1, loader1, key2, loader2);
    }

    private PGPPublicKeyRingCollection loadPublicKeyStore(ImmutableHierarchicalConfiguration config) throws KeyManagementException {
        PGPPublicKeyRingCollection pGPPublicKeyRingCollection;
        block8: {
            BufferedInputStream is = this.getResource(config);
            try {
                pGPPublicKeyRingCollection = PgpUtil.loadPublicKeys((InputStream)is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new KeyManagementException("Could not load PGP key ring. Error message: " + e.getMessage(), e);
                }
            }
            ((InputStream)is).close();
        }
        return pGPPublicKeyRingCollection;
    }

    private PGPSecretKeyRingCollection loadPrivateKeyStore(ImmutableHierarchicalConfiguration config) throws KeyManagementException {
        PGPSecretKeyRingCollection pGPSecretKeyRingCollection;
        block8: {
            BufferedInputStream is = this.getResource(config);
            try {
                pGPSecretKeyRingCollection = PgpUtil.loadSecretKeys((InputStream)is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new KeyManagementException("Could not load PGP key ring. Error message: " + e.getMessage(), e);
                }
            }
            ((InputStream)is).close();
        }
        return pGPSecretKeyRingCollection;
    }

    @Override
    protected void validateConfig(IKeySourceFactory.SourceData data) throws KeyManagementException {
        super.validateConfig(data);
        if (data.supportsConfidentiality(IKeySourceFactory.EConfidentiality.PRIVATE) && !data.config().containsKey(PASSWORD_KEY)) {
            throw new KeyManagementException("Configuration is missing mandatory 'password' parameter.");
        }
    }

    @Override
    public void supplyPasswordDecoder(IPasswordDecoderSupplier supplier) {
        this.passwordSupplier = supplier;
    }

    private static class LoaderStorerLinker<T extends IPublicCryptographyKey<PGPPublicKey>, U>
    implements IKeyLoader<T, U> {
        private final Function<PGPPublicKeyRingCollection, IKeyLoader<T, U>> creator;
        private final PgpKeyStoreStorer storer;
        private IKeyLoader<T, U> loader;

        public LoaderStorerLinker(Function<PGPPublicKeyRingCollection, IKeyLoader<T, U>> creator, PgpKeyStoreStorer storer) {
            this.creator = creator;
            this.storer = storer;
            storer.getInfoDataManager().register(this::handleInfo);
        }

        public T loadKey(U forId) {
            if (this.loader == null) {
                this.loader = this.createLoader();
            }
            return (T)((IPublicCryptographyKey)this.loader.loadKey(forId));
        }

        public EKeySource getKeySource() {
            return EKeySource.KEYSTORE;
        }

        public ECryptographyType getCryptography() {
            return ECryptographyType.PGP;
        }

        private IKeyLoader<T, U> createLoader() {
            return this.creator.apply(this.storer.getKeyStore());
        }

        public void handleInfo(InfoData info) {
            if (info.infoType == 200) {
                this.loader = null;
            }
        }
    }
}

