/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.key.source;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.Provider;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.loader.IKeyLoader;
import net.savignano.cryptography.key.loader.smime.SmimeCertificateKeyStoreLoader;
import net.savignano.cryptography.key.loader.smime.SmimeDecryptionKeyStoreLoader;
import net.savignano.cryptography.key.smime.SmimeDecryptionKey;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.cryptography.util.SmimeUtil;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSSignedData;
import net.savignano.thirdparty.org.bouncycastle.cms.KeyTransRecipientId;
import net.savignano.thirdparty.org.bouncycastle.util.Store;
import net.savignano.uptrust.service.config.converter.PasswordConverter;
import net.savignano.uptrust.service.key.manager.factory.INeedsPasswordDecoder;
import net.savignano.uptrust.service.key.source.AResourceSourceFactory;
import net.savignano.uptrust.service.key.source.IKeySourceFactory;
import net.savignano.uptrust.service.key.storer.IKeyStorer;
import net.savignano.uptrust.service.key.storer.SmimeKeyStoreStorer;
import net.savignano.uptrust.service.password.IPasswordDecoderSupplier;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.ImmutableHierarchicalConfiguration;
import org.apache.commons.lang3.tuple.Pair;

public class SmimeKeyStoreSourceFactory
extends AResourceSourceFactory
implements INeedsPasswordDecoder {
    public static final SmimeKeyStoreSourceFactory INSTANCE = new SmimeKeyStoreSourceFactory();
    private static final String PASSWORD_KEY = "password";
    private static final String TYPE_KEY = "type";
    private IPasswordDecoderSupplier passwordSupplier;

    private SmimeKeyStoreSourceFactory() {
    }

    @Override
    public boolean isResponsible(IKeySourceFactory.SourceData data) {
        return data != null && Objects.equals(data.sourceType(), "keystore") && data.supportsCryptography(ECryptographyType.SMIME);
    }

    @Override
    public IKeySourceFactory.KeySource create(IKeySourceFactory.SourceData data) throws KeyManagementException {
        if (!this.isResponsible(data)) {
            throw new KeyManagementException("The factory " + this.getClass().getSimpleName() + " cannot be used to create a key source for the given source data: " + String.valueOf(data));
        }
        this.validateConfig(data);
        KeyStore keyStore = this.isRealKeyStore(data) ? this.loadKeyStore(data.config()) : this.loadCertStore(data.config());
        return this.createLoaders(keyStore, data);
    }

    private IKeySourceFactory.KeySource createLoaders(KeyStore keyStore, IKeySourceFactory.SourceData data) {
        IKeySourceFactory.KeySource keySource = new IKeySourceFactory.KeySource(EKeySource.KEYSTORE);
        if (data.supportsConfidentiality(IKeySourceFactory.EConfidentiality.PUBLIC)) {
            Optional<File> file;
            keySource.keyLoaders().putAll(this.createPublicLoader(keyStore));
            if (!data.readOnly() && this.isRealKeyStore(data) && (file = this.getFile(data.config())).isPresent()) {
                keySource.keyStorers().putAll(this.createPublicStorer(keyStore, file.get()));
            }
        }
        if (data.supportsConfidentiality(IKeySourceFactory.EConfidentiality.PRIVATE)) {
            keySource.keyLoaders().putAll(this.createPrivateLoader(keyStore));
        }
        return keySource;
    }

    private boolean isRealKeyStore(IKeySourceFactory.SourceData data) {
        return !"PKCS7".equalsIgnoreCase(data.config().getString(TYPE_KEY));
    }

    private Map<Pair<Class<? extends ICryptographyKey<?>>, Class<?>>, IKeyLoader<?, ?>> createPublicLoader(KeyStore keyStore) {
        Pair key = Pair.of(SmimeEncryptionKey.class, String.class);
        SmimeCertificateKeyStoreLoader loader = new SmimeCertificateKeyStoreLoader(keyStore);
        return Map.of(key, loader);
    }

    private Map<Pair<Class<? extends ICryptographyKey<?>>, Class<?>>, IKeyLoader<?, ?>> createPrivateLoader(KeyStore keyStore) {
        Pair key = Pair.of(SmimeDecryptionKey.class, KeyTransRecipientId.class);
        SmimeDecryptionKeyStoreLoader loader = new SmimeDecryptionKeyStoreLoader(keyStore, null);
        return Map.of(key, loader);
    }

    private Map<Pair<Class<? extends ICryptographyKey<?>>, Class<?>>, IKeyStorer<?, ?>> createPublicStorer(KeyStore keyStore, File file) {
        Pair key = Pair.of(SmimeEncryptionKey.class, String.class);
        SmimeKeyStoreStorer loader = new SmimeKeyStoreStorer(keyStore, file);
        return Map.of(key, loader);
    }

    private KeyStore loadKeyStore(ImmutableHierarchicalConfiguration config) throws KeyManagementException {
        KeyStore keyStore;
        block8: {
            BufferedInputStream is = this.getResource(config);
            try {
                Provider provider = SecurityUtil.getProvider();
                KeyStore ks = KeyStore.getInstance(config.getString(TYPE_KEY), provider);
                char[] password = ((PasswordConverter)new PasswordConverter().from((ImmutableConfiguration)config, PASSWORD_KEY)).useDecoderSupplier(this.passwordSupplier).get(null);
                ks.load(is, password);
                keyStore = ks;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new KeyManagementException("Could not load key store. Error message: " + e.getMessage(), e);
                }
            }
            ((InputStream)is).close();
        }
        return keyStore;
    }

    private KeyStore loadCertStore(ImmutableHierarchicalConfiguration config) throws KeyManagementException {
        try {
            CMSSignedData signature;
            try (BufferedInputStream is = this.getResource(config);){
                signature = new CMSSignedData((InputStream)is);
            }
            Store certStore = signature.getCertificates();
            return SmimeUtil.convertToKeyStore((Store)certStore, (String)"BKS", null);
        }
        catch (Exception e) {
            throw new KeyManagementException("Could not load P7B. Error message: " + e.getMessage(), e);
        }
    }

    @Override
    protected void validateConfig(IKeySourceFactory.SourceData data) throws KeyManagementException {
        super.validateConfig(data);
        if (data.supportsConfidentiality(IKeySourceFactory.EConfidentiality.PRIVATE) && !data.config().containsKey(PASSWORD_KEY)) {
            throw new KeyManagementException("Configuration is missing mandatory 'password' parameter.");
        }
        if (!data.config().containsKey(TYPE_KEY)) {
            throw new KeyManagementException("Configuration is missing mandatory 'type' parameter.");
        }
    }

    @Override
    public void supplyPasswordDecoder(IPasswordDecoderSupplier supplier) {
        this.passwordSupplier = supplier;
    }
}

