/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.key.storer;

import net.savignano.cryptography.info.InfoData;
import net.savignano.cryptography.info.InfoDataManager;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.uptrust.service.key.storer.IKeyStorer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AKeyStorer<T extends ICryptographyKey<?>, U>
implements IKeyStorer<T, U> {
    public static final int INFO_STORED_KEY = 100;
    public static final int INFO_NO_KEY_STORED = 101;
    public static final int INFO_REMOVED_KEY = 102;
    public static final int INFO_NO_KEY_REMOVED = 103;
    public static final int INFO_ERROR = 104;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final InfoDataManager manager = new InfoDataManager();

    @Override
    public void storeKey(U forId, T key) {
        try {
            if (this.storeKeyInternal(forId, key)) {
                this.getLog().debug("Stored key for ID \"{}\": {}", forId, key);
                this.getInfoDataManager().send(new InfoData(100, new Object[]{key, forId}));
            } else {
                this.getInfoDataManager().send(new InfoData(101, new Object[]{key, forId}));
            }
        }
        catch (Exception e) {
            this.getLog().error("Could not store key for ID: " + String.valueOf(forId), (Throwable)e);
            this.getInfoDataManager().send(new InfoData(104, new Object[]{key, forId}));
        }
    }

    @Override
    public void removeKey(U forId) {
        try {
            if (this.removeKeyInternal(forId)) {
                this.getLog().debug("Removed key for ID: {}", forId);
                this.getInfoDataManager().send(new InfoData(102, new Object[]{forId}));
            } else {
                this.getInfoDataManager().send(new InfoData(103, new Object[]{forId}));
            }
        }
        catch (Exception e) {
            this.getLog().error("Could not remove key for ID: " + String.valueOf(forId), (Throwable)e);
            this.getInfoDataManager().send(new InfoData(104, new Object[]{forId}));
        }
    }

    protected abstract boolean storeKeyInternal(U var1, T var2) throws Exception;

    protected abstract boolean removeKeyInternal(U var1) throws Exception;

    public InfoDataManager getInfoDataManager() {
        return this.manager;
    }

    protected Logger getLog() {
        return this.log;
    }
}

