/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.key.storer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.info.InfoData;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import net.savignano.uptrust.service.key.storer.AKeyStorer;

public class PgpKeyStoreStorer
extends AKeyStorer<PgpEncryptionKey, String> {
    public static final int INFO_UPDATED_KEY_STORE = 200;
    private PGPPublicKeyRingCollection keyStore;
    private final File file;

    public PgpKeyStoreStorer(PGPPublicKeyRingCollection keyStore, File file) {
        this.keyStore = keyStore;
        this.file = file;
    }

    public PgpKeyStoreStorer(PGPPublicKeyRingCollection keyStore, String fileName) {
        this(keyStore, fileName == null ? null : new File(fileName));
    }

    @Override
    protected boolean storeKeyInternal(String forId, PgpEncryptionKey key) throws Exception {
        if (!key.isValid()) {
            this.getLog().debug("Cannot persist not valid key for ID \"{}\": {}", (Object)forId, (Object)key);
            return false;
        }
        PGPPublicKeyRing keyRing = key.getKeyRing();
        if (this.getKeyStore().contains(keyRing.getPublicKey().getKeyID())) {
            this.getLog().debug("Same key already present for ID: {}", (Object)forId);
            return false;
        }
        this.keyStore = PGPPublicKeyRingCollection.addPublicKeyRing((PGPPublicKeyRingCollection)this.getKeyStore(), (PGPPublicKeyRing)keyRing);
        this.getInfoDataManager().send(new InfoData(200, new Object[]{this.keyStore}));
        if (this.file != null) {
            this.write();
        }
        return true;
    }

    @Override
    protected boolean removeKeyInternal(String forId) throws Exception {
        PGPPublicKeyRing key = PgpUtil.getKeysForEmail((PGPPublicKeyRingCollection)this.getKeyStore(), (String)forId);
        if (key == null) {
            return false;
        }
        this.keyStore = PGPPublicKeyRingCollection.removePublicKeyRing((PGPPublicKeyRingCollection)this.getKeyStore(), (PGPPublicKeyRing)key);
        this.getInfoDataManager().send(new InfoData(200, new Object[]{this.keyStore}));
        if (this.file != null) {
            this.write();
        }
        return true;
    }

    private void write() throws IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.file));){
            this.keyStore.encode((OutputStream)os);
        }
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.KEYSTORE;
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.PGP;
    }

    public PGPPublicKeyRingCollection getKeyStore() {
        return this.keyStore;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PgpKeyStoreStorer [keyStore=");
        builder.append(this.keyStore);
        builder.append(", file=");
        builder.append(this.file);
        builder.append("]");
        return builder.toString();
    }
}

