/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.key.storer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;
import net.savignano.uptrust.service.key.storer.AKeyStorer;

public class SmimeKeyStoreStorer
extends AKeyStorer<SmimeEncryptionKey, String> {
    private final KeyStore keyStore;
    private final File file;

    public SmimeKeyStoreStorer(KeyStore keyStore, File file) {
        this.keyStore = keyStore;
        this.file = file;
    }

    public SmimeKeyStoreStorer(KeyStore keyStore, String fileName) {
        this(keyStore, fileName == null ? null : new File(fileName));
    }

    @Override
    protected boolean storeKeyInternal(String forId, SmimeEncryptionKey key) throws Exception {
        Certificate oldCert;
        if (!key.isValid()) {
            this.getLog().debug("Cannot persist not valid key for ID \"{}\": {}", (Object)forId, (Object)key);
            return false;
        }
        X509Certificate cert = key.getKey();
        if (cert.equals(oldCert = this.keyStore.getCertificate(forId))) {
            this.getLog().debug("Same certificate already present for ID: {}", (Object)forId);
            return false;
        }
        this.keyStore.setCertificateEntry(forId, cert);
        if (this.file != null) {
            this.write();
        }
        return true;
    }

    @Override
    protected boolean removeKeyInternal(String forId) throws Exception {
        if (!this.keyStore.containsAlias(forId)) {
            return false;
        }
        this.keyStore.deleteEntry(forId);
        if (this.file != null) {
            this.write();
        }
        return true;
    }

    private void write() throws Exception {
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.file));){
            this.keyStore.store(os, null);
        }
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.KEYSTORE;
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.SMIME;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SmimeKeyStoreStorer [keyStore=");
        builder.append(this.keyStore);
        builder.append(", file=");
        builder.append(this.file);
        builder.append("]");
        return builder.toString();
    }
}

