/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.license;

import java.security.PublicKey;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Optional;
import javax0.license3j.License;
import net.savignano.uptrust.service.license.ILicenseService;
import net.savignano.uptrust.service.license.LicenseServiceConfiguration;

public class LicenseService
implements ILicenseService {
    private static final String EXPIRY_DATE_KEY = "expiryDate";
    private final Optional<License> license;
    private final PublicKey key;

    public LicenseService(LicenseServiceConfiguration config) {
        if (config == null) {
            throw new IllegalAccessError("Configuration must not be null.");
        }
        this.license = config.getLicense();
        this.key = config.getPublicKey();
    }

    @Override
    public boolean isLicensed() {
        return this.license.isPresent();
    }

    @Override
    public boolean isExpired() {
        return this.isLicensed() && this.license.get().isExpired();
    }

    @Override
    public boolean isSigned() {
        return this.isLicensed() && this.key != null && this.license.get().isOK(this.key);
    }

    @Override
    public Optional<ZonedDateTime> getExpiryDate() {
        if (!this.isLicensed()) {
            return Optional.empty();
        }
        Date expiryDate = this.license.get().get(EXPIRY_DATE_KEY).getDate();
        Instant instant = Instant.ofEpochMilli(expiryDate.getTime());
        ZoneId zone = ZoneId.systemDefault();
        return Optional.of(ZonedDateTime.ofInstant(instant, zone));
    }
}

