/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.license;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.PublicKey;
import javax0.license3j.License;
import javax0.license3j.io.IOFormat;
import javax0.license3j.io.LicenseReader;
import net.savignano.cryptography.Constants;
import net.savignano.uptrust.service.config.converter.EnumConverter;
import net.savignano.uptrust.service.license.LicenseService;
import net.savignano.uptrust.service.license.LicenseServiceConfiguration;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.slf4j.LoggerFactory;

public class LicenseServiceBuilder {
    private static final String FORMAT_KEY = "format";
    private static final String FILE_KEY = "file";
    private static final String URL_KEY = "url";
    private static final String RAW_KEY = "raw";
    private final LicenseServiceConfiguration config = new LicenseServiceConfiguration();

    public static final LicenseServiceBuilder empty() {
        return new LicenseServiceBuilder();
    }

    public static final LicenseServiceBuilder from(ImmutableConfiguration config) {
        return LicenseServiceBuilder.empty().license(LicenseServiceBuilder.readLicense(config));
    }

    private static License readLicense(ImmutableConfiguration config) {
        IOFormat format = ((EnumConverter)new EnumConverter<IOFormat>(IOFormat.class).from(config, FORMAT_KEY)).get(IOFormat.BASE64);
        if (config.containsKey(RAW_KEY)) {
            return LicenseServiceBuilder.readRawLicense(config.getString(RAW_KEY), format);
        }
        if (config.containsKey(FILE_KEY)) {
            return LicenseServiceBuilder.readLicenseFromFile(config.getString(FILE_KEY), format);
        }
        if (config.containsKey(URL_KEY)) {
            return LicenseServiceBuilder.readLicenseFromUrl(config.getString(URL_KEY), format);
        }
        LoggerFactory.getLogger(LicenseServiceBuilder.class).error("No Uptrust license configured.");
        return null;
    }

    private static License readRawLicense(String rawLicense, IOFormat format) {
        LoggerFactory.getLogger(LicenseServiceBuilder.class).info("Reading raw Uptrust license data ({} format).", (Object)format);
        ByteArrayInputStream is = new ByteArrayInputStream(rawLicense.getBytes(Constants.UTF8_CHARSET));
        try {
            return LicenseServiceBuilder.readLicense(is, format);
        }
        catch (Exception e) {
            String shortenedLicense = rawLicense.length() > 16 ? rawLicense.substring(0, 8) + "..." + rawLicense.substring(rawLicense.length() - 8) : rawLicense;
            LoggerFactory.getLogger(LicenseServiceBuilder.class).error("Could not parse raw Uptrust license data \"" + shortenedLicense + "\" (Format: " + String.valueOf(format) + ").", (Throwable)e);
            return null;
        }
    }

    private static License readLicenseFromFile(String fileName, IOFormat format) {
        LoggerFactory.getLogger(LicenseServiceBuilder.class).info("Reading Uptrust license from file \"{}\" ({} format).", (Object)fileName, (Object)format);
        File file = new File(fileName);
        try {
            return LicenseServiceBuilder.readLicense(new FileInputStream(file), format);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(LicenseServiceBuilder.class).error("Could not read Uptrust license data from file \"" + String.valueOf(file) + "\" (Format: " + String.valueOf(format) + ").", (Throwable)e);
            return null;
        }
    }

    private static License readLicenseFromUrl(String licenseUrl, IOFormat format) {
        URL url;
        LoggerFactory.getLogger(LicenseServiceBuilder.class).info("Reading Uptrust license from URL \"{}\" ({} format).", (Object)licenseUrl, (Object)format);
        try {
            url = new URL(licenseUrl);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(LicenseServiceBuilder.class).error("Could not parse Uptrust license URL: " + licenseUrl, (Throwable)e);
            return null;
        }
        try {
            return LicenseServiceBuilder.readLicense(url.openStream(), format);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(LicenseServiceBuilder.class).error("Could not read Uptrust license data from URL \"" + String.valueOf(url) + "\" (Format: " + String.valueOf(format) + ").", (Throwable)e);
            return null;
        }
    }

    private static License readLicense(InputStream is, IOFormat format) throws IOException {
        try (LicenseReader reader = new LicenseReader((InputStream)new BufferedInputStream(is));){
            License license = reader.read(format);
            return license;
        }
    }

    private LicenseServiceBuilder() {
    }

    public LicenseServiceBuilder license(License license) {
        this.config.setLicense(license);
        return this;
    }

    public LicenseServiceBuilder validateWith(PublicKey key) {
        this.config.setPublicKey(key);
        return this;
    }

    public LicenseService build() {
        return new LicenseService(new LicenseServiceConfiguration(this.config));
    }
}

