/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.service.password;

import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.uptrust.service.password.IPasswordDecoder;
import net.savignano.uptrust.service.password.IPasswordDecoderSupplier;
import net.savignano.uptrust.service.password.IPasswordService;
import org.apache.commons.lang3.StringUtils;

public class PasswordService
implements IPasswordService,
IPasswordDecoderSupplier {
    private static final String PASSWORD_OBFUSCATION_KEY_PROP = "password.encryption.key";
    private static final String PASSWORD_KEY = System.getProperty("password.encryption.key");
    private static final Map<String, IPasswordService.PasswordAlgorithm> ALGORITHM_MAPPING = new HashMap<String, IPasswordService.PasswordAlgorithm>();

    @Override
    public String encodePassword(char[] value, IPasswordService.PasswordAlgorithm algorithm) throws GeneralSecurityException {
        if (value == null) {
            return null;
        }
        if (algorithm == null) {
            return new String(value);
        }
        return switch (algorithm) {
            default -> throw new IncompatibleClassChangeError();
            case IPasswordService.PasswordAlgorithm.NONE -> new String(value);
            case IPasswordService.PasswordAlgorithm.AES_CBC -> SecurityUtil.encode((char[])value, (String)this.getPasswordKey());
        };
    }

    @Override
    public char[] decodePasswordToChars(String value, IPasswordService.PasswordAlgorithm algorithm) throws GeneralSecurityException {
        if (value == null) {
            return null;
        }
        if (algorithm == null) {
            return value.toCharArray();
        }
        return switch (algorithm) {
            default -> throw new IncompatibleClassChangeError();
            case IPasswordService.PasswordAlgorithm.NONE -> value.toCharArray();
            case IPasswordService.PasswordAlgorithm.AES_CBC -> SecurityUtil.decodeCharsBase64Aes((String)value, (String)this.getPasswordKey());
        };
    }

    protected String getPasswordKey() {
        return PASSWORD_KEY;
    }

    protected IPasswordService.PasswordAlgorithm toAlgorithm(String strAlg) throws NoSuchAlgorithmException {
        IPasswordService.PasswordAlgorithm alg = ALGORITHM_MAPPING.get(StringUtils.toRootLowerCase((String)strAlg));
        if (alg != null) {
            return alg;
        }
        throw new NoSuchAlgorithmException("Algorithm \"" + strAlg + "\" is unknown.");
    }

    @Override
    public IPasswordDecoder getDecoder(String algorithm) throws NoSuchAlgorithmException {
        return val -> this.decodePasswordToChars(val, this.toAlgorithm(algorithm));
    }

    static {
        for (IPasswordService.PasswordAlgorithm alg : IPasswordService.PasswordAlgorithm.values()) {
            ALGORITHM_MAPPING.put(StringUtils.toRootLowerCase((String)alg.name()), alg);
            ALGORITHM_MAPPING.put(StringUtils.toRootLowerCase((String)alg.toString()), alg);
        }
        ALGORITHM_MAPPING.put(null, IPasswordService.PasswordAlgorithm.NONE);
        ALGORITHM_MAPPING.put("aes-cbc", IPasswordService.PasswordAlgorithm.AES_CBC);
    }
}

